/*
 * Decompiled with CFR 0.152.
 */
package org.opengauss.readwritesplitting;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.opengauss.readwritesplitting.ForceExecuteTemplate;
import org.opengauss.readwritesplitting.ReadWriteSplittingPgConnection;
import org.opengauss.readwritesplitting.SqlRouteEngine;

public class ReadWriteSplittingPgStatement
implements Statement {
    private final List<Statement> statements = new LinkedList<Statement>();
    private final ForceExecuteTemplate<Statement> forceExecuteTemplate = new ForceExecuteTemplate();
    private final ReadWriteSplittingPgConnection readWriteSplittingPgConnection;
    private final Integer resultSetType;
    private final Integer resultSetConcurrency;
    private final Integer resultSetHoldability;
    private Statement currentStatement;
    private ResultSet currentResultSet;
    private boolean isClosed;

    public ReadWriteSplittingPgStatement(ReadWriteSplittingPgConnection readWriteSplittingPgConnection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        this.readWriteSplittingPgConnection = readWriteSplittingPgConnection;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        ResultSet result;
        Statement pgStatement = this.createPgStatement(sql);
        this.currentResultSet = result = pgStatement.executeQuery(sql);
        return result;
    }

    private Statement createPgStatement(String sql) throws SQLException {
        Connection connection = SqlRouteEngine.getRoutedConnection(this.readWriteSplittingPgConnection, sql);
        Statement statement = connection.createStatement(this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability);
        this.statements.add(statement);
        this.currentStatement = statement;
        return statement;
    }

    public Statement getCurrentStatement() throws SQLException {
        if (this.currentStatement == null) {
            Statement statement = this.readWriteSplittingPgConnection.getConnectionManager().getCurrentConnection().createStatement();
            this.statements.add(statement);
            this.currentStatement = statement;
            return statement;
        }
        return this.currentStatement;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        Statement pgStatement = this.createPgStatement(sql);
        return pgStatement.execute(sql);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        Statement pgStatement = this.createPgStatement(sql);
        return pgStatement.execute(sql, autoGeneratedKeys);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        Statement pgStatement = this.createPgStatement(sql);
        return pgStatement.execute(sql, columnIndexes);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        Statement pgStatement = this.createPgStatement(sql);
        return pgStatement.execute(sql, columnNames);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        Statement pgStatement = this.createPgStatement(sql);
        return pgStatement.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        Statement pgStatement = this.createPgStatement(sql);
        return pgStatement.executeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        Statement pgStatement = this.createPgStatement(sql);
        return pgStatement.executeUpdate(sql, columnIndexes);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        Statement pgStatement = this.createPgStatement(sql);
        return pgStatement.executeUpdate(sql, columnNames);
    }

    public Collection<Statement> getRoutedStatements() {
        return this.statements;
    }

    @Override
    public void close() throws SQLException {
        this.isClosed = true;
        try {
            this.forceExecuteTemplate.execute(this.getRoutedStatements(), Statement::close);
        }
        finally {
            this.getRoutedStatements().clear();
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.currentResultSet;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this.getCurrentStatement().executeBatch();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.getCurrentStatement().getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.getCurrentStatement().setMaxFieldSize(max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.getCurrentStatement().getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.getCurrentStatement().setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean isEnabled) throws SQLException {
        this.getCurrentStatement().setEscapeProcessing(isEnabled);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.getCurrentStatement().getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.getCurrentStatement().setQueryTimeout(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        this.forceExecuteTemplate.execute(this.getRoutedStatements(), Statement::cancel);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.getCurrentStatement().getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.getCurrentStatement().clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.getCurrentStatement().setCursorName(name);
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.getCurrentStatement().getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getCurrentStatement().getMoreResults();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.getCurrentStatement().setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.getCurrentStatement().getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.getCurrentStatement().setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.getCurrentStatement().getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.getCurrentStatement().getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.getCurrentStatement().getResultSetType();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.getCurrentStatement().addBatch(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.getCurrentStatement().clearBatch();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.readWriteSplittingPgConnection;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.getCurrentStatement().getMoreResults();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.getCurrentStatement().getGeneratedKeys();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.getCurrentStatement().getResultSetHoldability();
    }

    @Override
    public void setPoolable(boolean isPoolable) throws SQLException {
        this.getCurrentStatement().setPoolable(isPoolable);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.getCurrentStatement().isPoolable();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.getCurrentStatement().closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.getCurrentStatement().isCloseOnCompletion();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.getCurrentStatement().unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.getCurrentStatement().isWrapperFor(iface);
    }
}

