/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.support.conv;

import com.cloudera.support.conv.ConversionResult;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class ExactNumConverter {
    private ExactNumConverter() {
        throw new UnsupportedOperationException();
    }

    public static double toDouble(BigDecimal bigDecimal, ConversionResult conversionResult) {
        Double d = bigDecimal.doubleValue();
        if (Double.POSITIVE_INFINITY == d) {
            conversionResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_LARGE);
        } else if (Double.NEGATIVE_INFINITY == d) {
            conversionResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_SMALL);
        } else {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
        }
        return d;
    }

    public static String toChar(BigDecimal bigDecimal, long l, ConversionResult conversionResult) {
        String string = bigDecimal.toString();
        if ((long)string.length() <= l) {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
        } else {
            conversionResult.setState(ConversionResult.TypeConversionState.STRING_RIGHT_TRUNCATION);
            string = string.substring(0, (int)l);
        }
        return string;
    }

    public static BigDecimal setPrecScale(BigDecimal bigDecimal, int n, int n2, ConversionResult conversionResult) {
        int n3;
        int n4;
        if (n < 1 || n2 > n || n2 < 0) {
            throw new IllegalArgumentException("Invalid precision scale");
        }
        int n5 = bigDecimal.precision() - bigDecimal.scale();
        if (n5 > (n4 = n - n2)) {
            if (bigDecimal.compareTo(BigDecimal.ZERO) < 0) {
                conversionResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_SMALL);
            } else {
                conversionResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_LARGE);
            }
            return null;
        }
        int n6 = n3 = bigDecimal.scale() <= 0 ? 0 : bigDecimal.scale();
        if (n3 <= n2) {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
            return bigDecimal;
        }
        BigDecimal bigDecimal2 = bigDecimal.setScale(n2, RoundingMode.DOWN);
        int n7 = bigDecimal.compareTo(bigDecimal2);
        if (n7 < 0) {
            conversionResult.setState(ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_UP);
        } else if (n7 == 0) {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
        } else {
            conversionResult.setState(ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_DOWN);
        }
        return bigDecimal2;
    }
}

