/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqlengine.executor.datawrapper;

import com.cloudera.dsi.dataengine.utilities.DataWrapper;
import com.cloudera.dsi.exceptions.IncorrectTypeException;
import com.cloudera.sqlengine.exceptions.SQLEngineException;
import com.cloudera.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.sqlengine.executor.datawrapper.DefaultSqlDataWrapper;
import com.cloudera.sqlengine.utilities.SQLEngineMessageKey;
import com.cloudera.support.exceptions.ErrorException;
import java.math.BigInteger;

public final class SqlBigIntDataWrapper
extends DefaultSqlDataWrapper {
    private BigInteger m_data = null;
    private boolean m_isSet = false;

    public BigInteger getBigInt() throws ErrorException {
        this.checkIsSet();
        return this.m_data;
    }

    public double getDouble() throws ErrorException {
        this.checkIsSet();
        return this.m_data.doubleValue();
    }

    public int getType() {
        return -5;
    }

    public boolean isNull() throws ErrorException {
        this.checkIsSet();
        return null == this.m_data;
    }

    public boolean isSet() {
        return this.m_isSet;
    }

    public void setBoolean(boolean bl) {
        this.m_isSet = true;
        this.m_data = bl ? BigInteger.ONE : BigInteger.ZERO;
    }

    public void setBigInt(BigInteger bigInteger) {
        this.m_isSet = true;
        this.m_data = bigInteger;
    }

    public void setInteger(long l) {
        this.setData(l);
    }

    public void setSmallInt(int n) {
        this.setData(n);
    }

    public void setTinyInt(short s) {
        this.setData(s);
    }

    public void setNull() {
        this.m_data = null;
        this.m_isSet = true;
    }

    public void setValue(DataWrapper dataWrapper) throws ErrorException {
        if (dataWrapper.isNull()) {
            this.setNull();
        } else {
            try {
                switch (dataWrapper.getType()) {
                    case 16: {
                        this.setBoolean(dataWrapper.getBoolean());
                        break;
                    }
                    case -5: {
                        this.setBigInt(dataWrapper.getBigInt());
                        break;
                    }
                    case -7: {
                        this.setBoolean(dataWrapper.getBit());
                        break;
                    }
                    case 4: {
                        this.setInteger(dataWrapper.getInteger());
                        break;
                    }
                    case 5: {
                        this.setSmallInt(dataWrapper.getSmallInt());
                        break;
                    }
                    case -6: {
                        this.setTinyInt(dataWrapper.getTinyInt());
                        break;
                    }
                    default: {
                        throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(dataWrapper.getType());
                    }
                }
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw new SQLEngineException(SQLEngineMessageKey.INVALID_OPERATION.name(), incorrectTypeException);
            }
        }
    }

    public void retrieveData(DataWrapper dataWrapper) throws ErrorException {
        this.checkIsSet();
        dataWrapper.setBigInt(this.m_data);
    }

    private void checkIsSet() throws ErrorException {
        if (!this.m_isSet) {
            throw SQLEngineExceptionFactory.requestedDataNotSet();
        }
    }

    private void setData(long l) {
        this.m_isSet = true;
        this.m_data = BigInteger.valueOf(l);
    }
}

