/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqlengine.dsiext.dataengine.ddl;

import com.cloudera.sqlengine.dsiext.dataengine.ddl.TableConstraint;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniqueConstraint
extends TableConstraint {
    private static final TableConstraint.ConstraintType CONSTRAINT_TYPE = TableConstraint.ConstraintType.UNIQUE;
    private Set<String> m_uniqueColumns;

    public UniqueConstraint(String string, Collection<String> collection) {
        super(string);
        if (collection == null || collection.size() == 0) {
            throw new IllegalArgumentException("Unique constarint require at least one column");
        }
        this.m_uniqueColumns = new HashSet<String>();
        this.m_uniqueColumns.addAll(collection);
    }

    public Set<String> getUniqueColumns() {
        return this.m_uniqueColumns;
    }

    @Override
    public TableConstraint.ConstraintType getType() {
        return CONSTRAINT_TYPE;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("UNIQUE COLUMN(");
        for (String string : this.m_uniqueColumns) {
            stringBuilder.append(string);
            stringBuilder.append(",");
        }
        stringBuilder.setLength(stringBuilder.length() - 1);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

