/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hivecommon.core;

import com.cloudera.dsi.core.impl.DSIDriverSingleton;
import com.cloudera.dsi.core.impl.DSILogger;
import com.cloudera.dsi.core.interfaces.IEnvironment;
import com.cloudera.dsi.core.interfaces.IStatement;
import com.cloudera.dsi.core.utilities.ConnSettingRequestMap;
import com.cloudera.dsi.core.utilities.ConnSettingResponseMap;
import com.cloudera.dsi.core.utilities.Variant;
import com.cloudera.dsi.exceptions.BadAuthException;
import com.cloudera.dsi.exceptions.IncorrectTypeException;
import com.cloudera.hivecommon.AuthMech;
import com.cloudera.hivecommon.BrandingPreferences;
import com.cloudera.hivecommon.HiveJDBCCasePreservingAlias;
import com.cloudera.hivecommon.HiveJDBCSettings;
import com.cloudera.hivecommon.HiveServerType;
import com.cloudera.hivecommon.IServerVersion;
import com.cloudera.hivecommon.KrbAuthType;
import com.cloudera.hivecommon.TransportMode;
import com.cloudera.hivecommon.api.HS2Client;
import com.cloudera.hivecommon.api.IHiveClient;
import com.cloudera.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.hivecommon.core.HiveJDBCStatement;
import com.cloudera.hivecommon.core.ThreadPoolExecutorExt;
import com.cloudera.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.jdbc.common.CommonCoreUtils;
import com.cloudera.jdbc.common.ProductInfoHandler;
import com.cloudera.jdbc.core.LoginTimeoutConnection;
import com.cloudera.jdbc.exceptions.CommonJDBCMessageKey;
import com.cloudera.jdbc.utils.HiveCommonGSSCredentialMap;
import com.cloudera.jdbc.utils.ParseQueryUtils;
import com.cloudera.sqlengine.dsiext.dataengine.IScalarFnMetadataHandler;
import com.cloudera.support.ILogger;
import com.cloudera.support.LogLevel;
import com.cloudera.support.LogUtilities;
import com.cloudera.support.Warning;
import com.cloudera.support.WarningCode;
import com.cloudera.support.exceptions.DiagState;
import com.cloudera.support.exceptions.ErrorException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.thrift.transport.TTransportException;

public abstract class HiveJDBCCommonConnection
extends LoginTimeoutConnection {
    protected static int s_connectionID = 0;
    protected static Object s_loggerLock = new Object();
    protected ILogger m_log;
    protected HiveJDBCSettings m_settings;
    protected IHiveClient m_hiveClient;
    private ExecutorService m_threadPool;
    private ConnSettingRequestMap m_requestMap;
    private boolean m_authMechSpecifiedByUser = false;
    private boolean m_transportModeSpecifiedByUser = false;
    private boolean m_useSasl = true;
    protected Map<String, Boolean> m_definedSettings = new TreeMap<String, Boolean>(String.CASE_INSENSITIVE_ORDER);

    protected HiveJDBCCommonConnection(IEnvironment iEnvironment) throws ErrorException {
        super(iEnvironment);
        this.setDefaultProperties();
        this.m_threadPool = new ThreadPoolExecutorExt(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    }

    public void cancelDelegationToken(String string) throws ErrorException {
        if (this.m_hiveClient instanceof HS2Client) {
            try {
                ((HS2Client)this.m_hiveClient).cancelDelegationToken(string);
            }
            catch (Exception exception) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CANCEL_DELEGATION_TOKEN_ERR.name(), new String[]{exception.getMessage(), string});
                errorException.initCause(exception);
                throw errorException;
            }
        } else {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.UNSUPPORTED_OPERATION_ERR.name(), "cancelDelegationToken");
            throw errorException;
        }
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        this.m_threadPool.shutdown();
    }

    @Override
    public IStatement createStatement() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        return new HiveJDBCStatement(this, this.m_requestMap);
    }

    @Override
    public void disconnect() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        if (null != this.m_hiveClient) {
            this.m_hiveClient.closeSession();
        }
    }

    @Override
    public void establishConnection(ConnSettingRequestMap connSettingRequestMap, int n) throws ErrorException, BadAuthException {
        Object object;
        Variant variant;
        Variant variant2;
        Variant variant3;
        block201: {
            block200: {
                Object object2;
                block199: {
                    block198: {
                        block197: {
                            block196: {
                                block192: {
                                    block191: {
                                        block190: {
                                            Object object3;
                                            block189: {
                                                block188: {
                                                    CommonCoreUtils.logConnectionFunctionEntrance(this.getConnectionLog(), connSettingRequestMap, 2, 5, 45, 1065);
                                                    this.m_requestMap = connSettingRequestMap;
                                                    this.m_settings = new HiveJDBCSettings();
                                                    this.setImplementationDefaultSettings();
                                                    this.m_definedSettings.put("Host", true);
                                                    this.m_settings.m_connDBType = this.getRequiredSetting("DatabaseType", connSettingRequestMap).getString();
                                                    this.m_definedSettings.put("DatabaseType", true);
                                                    this.m_settings.m_port = 10000;
                                                    this.m_settings.m_timeout = 0;
                                                    this.m_settings.m_rowsFetchedPerBlock = 10000;
                                                    this.m_settings.m_stringColumnSize = (short)255;
                                                    this.m_settings.m_asyncExecPollInterval = 10;
                                                    this.m_settings.m_authMech = AuthMech.NOAUTH;
                                                    this.m_settings.m_useNativeQuery = false;
                                                    this.m_settings.m_decimalColumnScale = (short)10;
                                                    this.m_settings.m_switchCataANDSchema = BrandingPreferences.defaultCatalogSchemaSwitch;
                                                    this.m_settings.m_preparedStmtGetMetadataLimitZero = true;
                                                    this.m_settings.m_lowercaseColumnNameAliase = HiveJDBCCasePreservingAlias.SERVER_DETERMINED;
                                                    this.m_settings.m_enableSSL = false;
                                                    this.m_settings.m_pushdownCatalogFunctionFilters = true;
                                                    this.getProductInfoHandler().validateLicense();
                                                    this.m_settings.m_optimizedInsert = false;
                                                    this.m_definedSettings.put("OptimizedInsert", true);
                                                    this.m_settings.m_stripCatalogName = true;
                                                    this.m_settings.m_supportTimeOnlyTimestamp = false;
                                                    this.m_settings.m_automaticColumnRename = false;
                                                    this.m_settings.m_tableNameColIndex = 0;
                                                    this.m_settings.m_isTemporaryColIndex = 1;
                                                    this.m_settings.m_fetchEndWaitTime = 5L;
                                                    this.m_settings.m_nonSSPs = new ArrayList<String>();
                                                    this.m_settings.m_nonSSPs.add("driver");
                                                    this.m_settings.m_nonSSPs.add("url");
                                                    this.m_settings.m_serverVersion = this.m_settings.m_platformVersionUtils.parseServerVersion("AUTO");
                                                    variant3 = this.getOptionalSetting("ServerVersion", connSettingRequestMap);
                                                    this.m_definedSettings.put("ServerVersion", true);
                                                    if (variant3 != null) {
                                                        try {
                                                            IServerVersion iServerVersion;
                                                            this.m_settings.m_strServerVersion = variant3.getString();
                                                            this.m_settings.m_serverVersion = iServerVersion = this.m_settings.m_platformVersionUtils.parseServerVersion(variant3.getString());
                                                        }
                                                        catch (Exception exception) {
                                                            if (null == this.getWarningListener()) break block188;
                                                            this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR.name(), new String[]{variant3.getString(), "ServerVersion"}));
                                                        }
                                                    }
                                                }
                                                this.m_settings.m_fastConnect = false;
                                                variant3 = this.getOptionalSetting("FastConnection", connSettingRequestMap);
                                                this.m_definedSettings.put("FastConnection", true);
                                                if (variant3 != null) {
                                                    try {
                                                        boolean bl;
                                                        this.m_settings.m_fastConnect = bl = variant3.getInt() == 1;
                                                    }
                                                    catch (Exception exception) {
                                                        if (null == this.getWarningListener()) break block189;
                                                        this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR.name(), new String[]{variant3.getString(), "FastConnection", "0, 1"}));
                                                    }
                                                }
                                            }
                                            variant2 = this.getOptionalSetting("zk", connSettingRequestMap);
                                            this.m_definedSettings.put("zk", true);
                                            if (null != variant2) {
                                                this.m_settings.m_dynamicServerDiscovery = true;
                                                object3 = variant2.getString();
                                                this.m_settings.m_hiveServerType = HiveServerType.HiveServer2;
                                                this.m_definedSettings.put("HiveServerType", true);
                                                try {
                                                    object2 = ((String)object3).split(",");
                                                    this.m_settings.m_zooKeeperServers = object2;
                                                }
                                                catch (Exception exception) {
                                                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DYNAMIC_DISCOVERY_ERROR.name(), exception.getMessage());
                                                    errorException.initCause(exception);
                                                    throw errorException;
                                                }
                                            }
                                            this.m_settings.m_dynamicServerDiscovery = false;
                                            this.m_settings.m_host = this.getRequiredSetting("Host", connSettingRequestMap).getString();
                                            object3 = this.getRequiredSetting("Port", connSettingRequestMap);
                                            this.m_definedSettings.put("Port", true);
                                            object2 = this.getRequiredSetting("HiveServerType", connSettingRequestMap);
                                            this.m_definedSettings.put("HiveServerType", true);
                                            try {
                                                this.m_settings.m_port = ((Variant)object3).getInt();
                                                if (1 == ((Variant)object2).getInt()) {
                                                    this.m_settings.m_hiveServerType = HiveServerType.HiveServer1;
                                                } else if (2 == ((Variant)object2).getInt()) {
                                                    this.m_settings.m_hiveServerType = HiveServerType.HiveServer2;
                                                }
                                            }
                                            catch (Exception exception) {
                                                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_HIVESERVERTYPE_ERR.name(), exception.getMessage());
                                                errorException.initCause(exception);
                                                throw errorException;
                                            }
                                            variant3 = this.getOptionalSetting("ssl", connSettingRequestMap);
                                            this.m_definedSettings.put("ssl", true);
                                            if (variant3 != null) {
                                                try {
                                                    boolean bl;
                                                    boolean bl2 = bl = variant3.getInt() == 1;
                                                    this.m_settings.m_enableSSL = bl;
                                                }
                                                catch (Exception exception) {
                                                    object2 = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_CONF_ERROR.name(), new String[]{"ssl", variant3.getString(), "0 , 1"});
                                                    ((Throwable)object2).initCause(exception);
                                                    throw object2;
                                                }
                                            }
                                            if (this.m_settings.m_platformVersionUtils.usesTransportMode()) {
                                                variant3 = this.getOptionalSetting("transportMode", connSettingRequestMap);
                                                this.m_definedSettings.put("transportMode", true);
                                                if (variant3 != null) {
                                                    try {
                                                        String string = variant3.getString();
                                                        this.m_transportModeSpecifiedByUser = true;
                                                        if (string.equalsIgnoreCase("http") && this.m_settings.m_platformVersionUtils.supportsHttpTransportMode(this.m_settings.m_serverVersion)) {
                                                            this.m_settings.m_transportMode = TransportMode.HTTP;
                                                        } else if (string.equalsIgnoreCase("binary")) {
                                                            this.m_settings.m_transportMode = TransportMode.BINARY;
                                                        } else if (string.equalsIgnoreCase("sasl")) {
                                                            this.m_settings.m_transportMode = TransportMode.SASL;
                                                        } else {
                                                            this.m_settings.m_transportMode = TransportMode.SASL;
                                                            this.m_transportModeSpecifiedByUser = false;
                                                            if (null != this.getWarningListener()) {
                                                                this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_INVALID_TRANSPORT_MODE_ERROR.name(), new String[]{variant3.getString()}));
                                                            }
                                                        }
                                                        break block190;
                                                    }
                                                    catch (Exception exception) {
                                                        this.m_settings.m_transportMode = this.m_settings.m_transportMode = TransportMode.SASL;
                                                        this.m_transportModeSpecifiedByUser = false;
                                                        if (null != this.getWarningListener()) {
                                                            this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_INVALID_TRANSPORT_MODE_ERROR.name(), new String[]{variant3.getString()}));
                                                        }
                                                        break block190;
                                                    }
                                                }
                                                this.m_settings.m_transportMode = TransportMode.SASL;
                                            } else {
                                                this.m_settings.m_transportMode = TransportMode.SASL;
                                                variant3 = this.getOptionalSetting("UseSasl", connSettingRequestMap);
                                                this.m_definedSettings.put("UseSasl", true);
                                                if (variant3 != null) {
                                                    try {
                                                        this.m_useSasl = variant3.getInt() == 1;
                                                    }
                                                    catch (Exception exception) {
                                                        object2 = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_CONF_ERROR.name(), new String[]{"UseSasl", variant3.getString(), "0 , 1"});
                                                        ((Throwable)object2).initCause(exception);
                                                        throw object2;
                                                    }
                                                }
                                            }
                                        }
                                        if (TransportMode.HTTP == this.m_settings.m_transportMode) {
                                            variant3 = this.getOptionalSetting("httpPath", connSettingRequestMap);
                                            this.m_definedSettings.put("httpPath", true);
                                            if (variant3 != null) {
                                                this.m_settings.m_httpPath = variant3.getString();
                                            }
                                        }
                                        variant3 = this.getOptionalSetting("AuthMech", connSettingRequestMap);
                                        this.m_definedSettings.put("AuthMech", true);
                                        if (variant3 != null) {
                                            try {
                                                int n2 = variant3.getInt();
                                                if (n2 >= AuthMech.values().length || n2 < 0) break block191;
                                                this.m_settings.m_authMech = AuthMech.values()[n2];
                                                this.m_authMechSpecifiedByUser = true;
                                                if (AuthMech.NOAUTH_SSL == this.m_settings.m_authMech) {
                                                    this.m_settings.m_authMech = AuthMech.NOAUTH;
                                                    this.m_settings.m_transportMode = TransportMode.BINARY;
                                                    this.m_settings.m_enableSSL = true;
                                                } else if (AuthMech.SASL_PLAIN_UIDPWD_SSL == this.m_settings.m_authMech) {
                                                    this.m_settings.m_authMech = AuthMech.UIDPWD;
                                                    this.m_settings.m_transportMode = TransportMode.SASL;
                                                    this.m_settings.m_enableSSL = true;
                                                }
                                                if (TransportMode.HTTP == this.m_settings.m_transportMode && AuthMech.UIDPWD != this.m_settings.m_authMech && AuthMech.SASL_KERBEROS != this.m_settings.m_authMech) {
                                                    if (null != this.getWarningListener()) {
                                                        this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_INVALID_AUTH_MECH_ERROR.name(), new String[]{this.m_settings.m_authMech.toString()}));
                                                    }
                                                    this.m_settings.m_authMech = AuthMech.UIDPWD;
                                                    this.m_authMechSpecifiedByUser = false;
                                                    if (null != this.getWarningListener()) {
                                                        this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_AUTH_MECH_SET_TO_DEFAULT.name(), new String[]{this.m_settings.m_authMech.toString()}));
                                                    }
                                                }
                                                if (this.m_transportModeSpecifiedByUser) {
                                                    if (!this.isAuthMechValid(this.m_settings)) {
                                                        this.m_settings.m_authMech = this.m_settings.m_platformVersionUtils.resolveDefaultAuthMech(this.m_settings);
                                                        this.m_authMechSpecifiedByUser = false;
                                                        if (null != this.getWarningListener()) {
                                                            this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_AUTH_MECH_SET_TO_DEFAULT.name(), new String[]{this.m_settings.m_authMech.toString()}));
                                                        }
                                                    }
                                                } else if (AuthMech.NOAUTH == this.m_settings.m_authMech || AuthMech.UIDPWD == this.m_settings.m_authMech && !this.m_useSasl) {
                                                    this.m_settings.m_transportMode = TransportMode.BINARY;
                                                }
                                                break block191;
                                            }
                                            catch (Exception exception) {
                                                this.m_settings.m_authMech = this.m_settings.m_platformVersionUtils.resolveDefaultAuthMech(this.m_settings);
                                                this.m_authMechSpecifiedByUser = false;
                                                if (null != this.getWarningListener()) {
                                                    this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_AUTH_MECH_SET_TO_DEFAULT.name(), new String[]{this.m_settings.m_authMech.toString()}));
                                                }
                                                break block191;
                                            }
                                        }
                                        this.m_settings.m_authMech = this.m_settings.m_platformVersionUtils.resolveDefaultAuthMech(this.m_settings);
                                        this.m_authMechSpecifiedByUser = false;
                                        if (null != this.getWarningListener()) {
                                            this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_AUTH_MECH_SET_TO_DEFAULT.name(), new String[]{this.m_settings.m_authMech.toString()}));
                                        }
                                        if (AuthMech.NOAUTH == this.m_settings.m_authMech) {
                                            this.m_settings.m_transportMode = TransportMode.BINARY;
                                        }
                                    }
                                    variant3 = this.getOptionalSetting("ConnSchema", connSettingRequestMap);
                                    this.m_definedSettings.put("ConnSchema", true);
                                    if (null == variant3 || variant3.getString().equals("NULL")) {
                                        this.m_settings.m_Schema = "default";
                                        if (null != this.getWarningListener()) {
                                            this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_DEFAULT_PROP_ERR_SCHEMA_NAME_NOT_DEFINED.name()));
                                        }
                                    } else {
                                        this.m_settings.m_Schema = variant3.getString();
                                    }
                                    variant3 = this.getOptionalSetting("KrbHostFQDN", connSettingRequestMap);
                                    this.m_definedSettings.put("KrbHostFQDN", true);
                                    if (variant3 != null) {
                                        this.m_settings.m_krbHostFQDN = variant3.getString();
                                        if (!this.m_settings.m_dynamicServerDiscovery && this.m_settings.m_krbHostFQDN.equals("_HOST")) {
                                            this.m_settings.m_krbHostFQDN = this.m_settings.m_host;
                                        }
                                    }
                                    variant3 = this.getOptionalSetting("KrbRealm", connSettingRequestMap);
                                    this.m_definedSettings.put("KrbRealm", true);
                                    if (variant3 != null) {
                                        this.m_settings.m_krbRealm = variant3.getString();
                                    }
                                    variant3 = this.getOptionalSetting("KrbServiceName", connSettingRequestMap);
                                    this.m_definedSettings.put("KrbServiceName", true);
                                    if (variant3 != null) {
                                        this.m_settings.m_krbServiceName = variant3.getString();
                                    }
                                    this.m_settings.m_krbAuthType = KrbAuthType.AUTO_DETECT;
                                    variant3 = this.getOptionalSetting("krbAuthType", connSettingRequestMap);
                                    this.m_definedSettings.put("krbAuthType", true);
                                    if (variant3 != null) {
                                        try {
                                            int n3 = variant3.getInt();
                                            if (n3 < KrbAuthType.values().length && n3 >= 0) {
                                                this.m_settings.m_krbAuthType = KrbAuthType.values()[n3];
                                            } else if (null != this.getWarningListener()) {
                                                this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_KERBEROS_AUTHENTICATION_INVALID_KRB_AUTH_TYPE.name()));
                                            }
                                        }
                                        catch (Exception exception) {
                                            if (null == this.getWarningListener()) break block192;
                                            this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_KERBEROS_AUTHENTICATION_INVALID_KRB_AUTH_TYPE.name()));
                                        }
                                    }
                                }
                                this.m_settings.m_username = null;
                                this.m_settings.m_password = null;
                                this.m_definedSettings.put("UID", true);
                                if (AuthMech.SASL_PLAIN_UID == this.m_settings.m_authMech || AuthMech.UIDPWD == this.m_settings.m_authMech) {
                                    if (this.m_authMechSpecifiedByUser) {
                                        variant3 = this.getRequiredSetting("UID", connSettingRequestMap);
                                        this.m_settings.m_username = variant3.getString();
                                    } else {
                                        variant3 = this.getOptionalSetting("UID", connSettingRequestMap);
                                        if (variant3 != null) {
                                            this.m_settings.m_username = variant3.getString();
                                        }
                                        if (this.m_settings.m_username == null || this.m_settings.m_username.length() == 0) {
                                            this.m_settings.m_username = "anonymous";
                                            if (null != this.getWarningListener()) {
                                                this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_PARAMETER_NOT_SET.name(), new String[]{"UID", "anonymous"}));
                                            }
                                        }
                                    }
                                }
                                this.m_definedSettings.put("PWD", true);
                                if (AuthMech.UIDPWD == this.m_settings.m_authMech) {
                                    if (this.m_authMechSpecifiedByUser) {
                                        variant3 = this.getRequiredSetting("PWD", connSettingRequestMap);
                                        this.m_settings.m_password = variant3.getString();
                                    } else {
                                        variant3 = this.getOptionalSetting("PWD", connSettingRequestMap);
                                        if (variant3 != null) {
                                            this.m_settings.m_password = variant3.getString();
                                        }
                                        if (this.m_settings.m_password == null || this.m_settings.m_password.length() == 0) {
                                            this.m_settings.m_password = "anonymous";
                                            if (null != this.getWarningListener()) {
                                                this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_PARAMETER_NOT_SET.name(), new String[]{"PWD", "anonymous"}));
                                            }
                                        }
                                    }
                                }
                                this.m_definedSettings.put("SSLKeyStore", true);
                                this.m_definedSettings.put("SSLKeyStorePwd", true);
                                this.m_definedSettings.put("SSLTrustStore", true);
                                this.m_definedSettings.put("SSLTrustStorePwd", true);
                                this.m_definedSettings.put("AllowSelfSignedCerts", true);
                                this.m_definedSettings.put("CAIssuedCertNamesMismatch", true);
                                this.m_definedSettings.put("SubjectAlternativeNamesHostNames", true);
                                if (this.m_settings.m_enableSSL) {
                                    block195: {
                                        block194: {
                                            block193: {
                                                variant3 = this.getOptionalSetting("SSLKeyStore", connSettingRequestMap);
                                                if (null != variant3) {
                                                    this.m_settings.m_sslKeyStore = variant3.getString();
                                                }
                                                if (null != (variant3 = this.getOptionalSetting("SSLKeyStorePwd", connSettingRequestMap))) {
                                                    this.m_settings.m_sslKeyStorePwd = variant3.getString();
                                                }
                                                if (null != (variant3 = this.getOptionalSetting("SSLTrustStore", connSettingRequestMap))) {
                                                    this.m_settings.m_sslTrustStore = variant3.getString();
                                                }
                                                if (null != (variant3 = this.getOptionalSetting("SSLTrustStorePwd", connSettingRequestMap))) {
                                                    this.m_settings.m_sslTrustStorePwd = variant3.getString();
                                                }
                                                this.m_settings.m_allowSelfSigned = false;
                                                variant3 = this.getOptionalSetting("AllowSelfSignedCerts", connSettingRequestMap);
                                                if (variant3 != null) {
                                                    try {
                                                        if (1 == variant3.getInt()) {
                                                            this.m_settings.m_allowSelfSigned = true;
                                                        }
                                                    }
                                                    catch (Exception exception) {
                                                        if (null == this.getWarningListener()) break block193;
                                                        this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR.name(), new String[]{variant3.getString(), "AllowSelfSignedCerts", "false"}));
                                                    }
                                                }
                                            }
                                            this.m_settings.m_certNamesMismatch = false;
                                            variant3 = this.getOptionalSetting("AllowAllHostNames", connSettingRequestMap);
                                            this.m_definedSettings.put("AllowAllHostNames", true);
                                            if (variant3 != null) {
                                                try {
                                                    if (1 == variant3.getInt()) {
                                                        this.m_settings.m_certNamesMismatch = true;
                                                    }
                                                }
                                                catch (Exception exception) {
                                                    if (null == this.getWarningListener()) break block194;
                                                    this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR.name(), new String[]{variant3.getString(), "AllowAllHostNames", "false"}));
                                                }
                                            }
                                        }
                                        if (!this.m_settings.m_certNamesMismatch && (variant3 = this.getOptionalSetting("CAIssuedCertNamesMismatch", connSettingRequestMap)) != null) {
                                            try {
                                                if (1 == variant3.getInt()) {
                                                    this.m_settings.m_certNamesMismatch = true;
                                                }
                                            }
                                            catch (Exception exception) {
                                                if (null == this.getWarningListener()) break block195;
                                                this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR.name(), new String[]{variant3.getString(), "CAIssuedCertNamesMismatch", "false"}));
                                            }
                                        }
                                    }
                                    this.m_settings.m_hostNameInSAN = true;
                                    variant3 = this.getOptionalSetting("SubjectAlternativeNamesHostNames", connSettingRequestMap);
                                    if (variant3 != null) {
                                        try {
                                            this.m_settings.m_hostNameInSAN = variant3.getInt() == 1;
                                        }
                                        catch (Exception exception) {
                                            object2 = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_CONF_ERROR.name(), new String[]{"SubjectAlternativeNamesHostNames", variant3.getString(), "0 , 1"});
                                            ((Throwable)object2).initCause(exception);
                                            throw object2;
                                        }
                                    }
                                }
                                variant3 = this.getOptionalSetting("UseNativeQuery", connSettingRequestMap);
                                this.m_definedSettings.put("UseNativeQuery", true);
                                if (null != variant3) {
                                    try {
                                        this.m_settings.m_useNativeQuery = variant3.getInt() == 1;
                                    }
                                    catch (Exception exception) {
                                        object2 = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_NATIVEMODE_ERR.name(), exception.getMessage());
                                        ((Throwable)object2).initCause(exception);
                                        throw object2;
                                    }
                                }
                                variant3 = this.getOptionalSetting("DelegationUID", connSettingRequestMap);
                                this.m_definedSettings.put("DelegationUID", true);
                                if (null != variant3) {
                                    try {
                                        this.m_settings.m_delegationUID = variant3.getString();
                                    }
                                    catch (Exception exception) {
                                        object2 = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DELEGATIONUID_ERR.name(), exception.getMessage());
                                        ((Throwable)object2).initCause(exception);
                                        throw object2;
                                    }
                                }
                                variant3 = this.getOptionalSetting("DefaultStringColumnLength", connSettingRequestMap);
                                this.m_definedSettings.put("DefaultStringColumnLength", true);
                                if (null != variant3) {
                                    try {
                                        this.m_settings.m_stringColumnSize = variant3.getShort();
                                        if (this.m_settings.m_stringColumnSize <= 0 || this.m_settings.m_stringColumnSize > Short.MAX_VALUE) {
                                            this.m_settings.m_stringColumnSize = (short)255;
                                            if (null != this.getWarningListener()) {
                                                this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_STRINGCOLUMNSIZE_ERR.name(), new String[]{"Column size value is invalid."}));
                                            }
                                        }
                                    }
                                    catch (Exception exception) {
                                        this.m_settings.m_stringColumnSize = (short)255;
                                        if (null == this.getWarningListener()) break block196;
                                        this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_STRINGCOLUMNSIZE_ERR.name(), new String[]{"Column size data type is invalid."}));
                                    }
                                }
                            }
                            variant3 = this.getOptionalSetting("AsyncExecPollInterval", connSettingRequestMap);
                            this.m_definedSettings.put("AsyncExecPollInterval", true);
                            if (null != variant3) {
                                try {
                                    this.m_settings.m_asyncExecPollInterval = variant3.getInt();
                                    if (0 >= this.m_settings.m_asyncExecPollInterval) {
                                        this.m_settings.m_asyncExecPollInterval = 10;
                                        if (null != this.getWarningListener()) {
                                            this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_ASYNCEXECPOLLINTERVAL_ERR.name()));
                                        }
                                    }
                                }
                                catch (Exception exception) {
                                    this.m_settings.m_asyncExecPollInterval = 10;
                                    if (null == this.getWarningListener()) break block197;
                                    this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_ASYNCEXECPOLLINTERVAL_ERR.name()));
                                }
                            }
                        }
                        variant3 = this.getOptionalSetting("FetchEndWaitTime", connSettingRequestMap);
                        this.m_definedSettings.put("FetchEndWaitTime", true);
                        if (null != variant3) {
                            try {
                                this.m_settings.m_fetchEndWaitTime = variant3.getLong();
                            }
                            catch (Exception exception) {
                                this.m_settings.m_fetchEndWaitTime = 5L;
                                if (null == this.getWarningListener()) break block198;
                                this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR.name(), new String[]{variant3.getString(), "FetchEndWaitTime", String.valueOf(5L)}));
                            }
                        }
                    }
                    variant = this.getOptionalSetting("SocketTimeOut", connSettingRequestMap);
                    this.m_definedSettings.put("SocketTimeOut", true);
                    if (null != variant) {
                        try {
                            this.m_settings.m_timeout = variant.getInt() * 1000;
                            if (this.m_settings.m_timeout < 0) {
                                this.m_settings.m_timeout = 0;
                                if (null != this.getWarningListener()) {
                                    this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_SOCKETTIMEOUT_ERR.name(), new String[]{"Timeout value cannot be negative."}));
                                }
                            }
                        }
                        catch (Exception exception) {
                            this.m_settings.m_timeout = 0;
                            if (null == this.getWarningListener()) break block199;
                            this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_SOCKETTIMEOUT_ERR.name(), new String[]{"Timeout value must be an integer."}));
                        }
                    }
                }
                object2 = this.getOptionalSetting("RowsFetchedPerBlock", connSettingRequestMap);
                this.m_definedSettings.put("RowsFetchedPerBlock", true);
                if (null != object2) {
                    try {
                        this.m_settings.m_rowsFetchedPerBlock = ((Variant)object2).getInt();
                        if (this.m_settings.m_rowsFetchedPerBlock < 0) {
                            this.m_settings.m_rowsFetchedPerBlock = 10000;
                            if (null != this.getWarningListener()) {
                                this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_ROWSFETCHEDPERBLOCK_ERR.name(), new String[]{"Value of RowsFetchedPerBlock cannot be negative."}));
                            }
                        }
                    }
                    catch (Exception exception) {
                        this.m_settings.m_rowsFetchedPerBlock = 10000;
                        if (null == this.getWarningListener()) break block200;
                        this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_ROWSFETCHEDPERBLOCK_ERR.name(), new String[]{"Value of RowsFetchedPerBlock must be an integer."}));
                    }
                }
            }
            Variant variant4 = this.getOptionalSetting("DecimalColumnScale", connSettingRequestMap);
            this.m_definedSettings.put("DecimalColumnScale", true);
            if (null != variant4) {
                try {
                    this.m_settings.m_decimalColumnScale = variant4.getShort();
                    if (this.m_settings.m_decimalColumnScale < 0 || this.m_settings.m_decimalColumnScale > 38) {
                        this.m_settings.m_decimalColumnScale = (short)10;
                        if (null != this.getWarningListener()) {
                            this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_ROWSFETCHEDPERBLOCK_ERR.name(), new String[]{"Value of Decimal Column Scale must be less than 38 and greater or equal to 0."}));
                        }
                    }
                }
                catch (Exception exception) {
                    this.m_settings.m_decimalColumnScale = (short)10;
                    if (null == this.getWarningListener()) break block201;
                    this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_DECIMALCOLUMNSCALE_ERR.name(), new String[]{"Value of RowsFetchedPerBlock must be an integer."}));
                }
            }
        }
        variant3 = this.getOptionalSetting("CatalogSchemaSwitch", connSettingRequestMap);
        this.m_definedSettings.put("CatalogSchemaSwitch", true);
        if (null != variant3) {
            try {
                if (variant3.getInt() == 0) {
                    this.m_settings.m_switchCataANDSchema = false;
                }
            }
            catch (IncorrectTypeException incorrectTypeException) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_SWITCHCATASCHEMA_TYPE_ERR.name(), incorrectTypeException.getMessage());
                errorException.initCause(incorrectTypeException);
                throw errorException;
            }
            catch (Exception exception) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_SWITCHCATASCHEMA_ERR.name(), exception.getMessage());
                errorException.initCause(exception);
                throw errorException;
            }
        }
        variant3 = this.getOptionalSetting("PreparedMetaLimitZero", connSettingRequestMap);
        this.m_definedSettings.put("PreparedMetaLimitZero", true);
        if (null != variant3) {
            try {
                this.m_settings.m_preparedStmtGetMetadataLimitZero = variant3.getInt() == 1;
            }
            catch (IncorrectTypeException incorrectTypeException) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_PREPAREDMETALIMITZERO_TYPE_ERR.name(), incorrectTypeException.getMessage());
                errorException.initCause(incorrectTypeException);
                throw errorException;
            }
            catch (Exception exception) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_PREPAREDMETALIMITZERO_ERR.name(), exception.getMessage());
                errorException.initCause(exception);
                throw errorException;
            }
        }
        variant3 = this.getOptionalSetting("LowerCaseResultSetColumnName", connSettingRequestMap);
        this.m_definedSettings.put("LowerCaseResultSetColumnName", true);
        if (null != variant3) {
            try {
                if (variant3.getInt() == 0) {
                    this.m_settings.m_lowercaseColumnNameAliase = HiveJDBCCasePreservingAlias.PRESERVE_CASE;
                } else if (variant3.getInt() == 1) {
                    this.m_settings.m_lowercaseColumnNameAliase = HiveJDBCCasePreservingAlias.LOWERCASE;
                }
            }
            catch (Exception exception) {
                this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_LOWERCASE_COLUMNNAME_ALIASE_ERROR.name()));
            }
        }
        variant3 = this.getOptionalSetting("PushdownCatalogFunctionFilters", connSettingRequestMap);
        this.m_definedSettings.put("PushdownCatalogFunctionFilters", true);
        if (null != variant3) {
            try {
                this.m_settings.m_pushdownCatalogFunctionFilters = variant3.getInt() == 1;
            }
            catch (Exception exception) {
                this.m_settings.m_pushdownCatalogFunctionFilters = true;
                this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_PUSHDOWN_CATALOG_FUNCTION_FILTERS_ERROR.name()));
            }
        }
        variant3 = this.getOptionalSetting("StripCatalogName", connSettingRequestMap);
        this.m_definedSettings.put("StripCatalogName", true);
        if (null != variant3) {
            try {
                if (0 == variant3.getInt() && !this.m_settings.m_useNativeQuery) {
                    this.m_settings.m_stripCatalogName = false;
                }
            }
            catch (IncorrectTypeException incorrectTypeException) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_STRIPCATALOGNAME_TYPE_ERR.name(), incorrectTypeException.getMessage());
                errorException.initCause(incorrectTypeException);
                throw errorException;
            }
            catch (Exception exception) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_STRIPCATALOGNAME_ERR.name(), exception.getMessage());
                errorException.initCause(exception);
                throw errorException;
            }
        }
        if (this.m_settings.m_switchCataANDSchema) {
            this.m_settings.m_stripCatalogName = false;
        }
        variant3 = this.getOptionalSetting("userGSSCredentialID", connSettingRequestMap);
        this.m_definedSettings.put("userGSSCredentialID", true);
        if (null != variant3 && null != (object = HiveCommonGSSCredentialMap.get(variant3.getString()))) {
            this.m_settings.m_userGSSCredential = object;
            HiveCommonGSSCredentialMap.remove(variant3.getString());
        }
        this.m_settings.m_useCustomCoercionMap = true;
        variant3 = this.getOptionalSetting("UseCustomTypeCoercionMap", connSettingRequestMap);
        this.m_definedSettings.put("UseCustomTypeCoercionMap", true);
        if (null != variant3) {
            try {
                this.m_settings.m_useCustomCoercionMap = variant3.getInt() == 1;
            }
            catch (Exception exception) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_CONF_ERROR.name(), new String[]{"UseCustomTypeCoercionMap", variant3.getString(), "0 , 1"});
                errorException.initCause(exception);
                throw errorException;
            }
        }
        variant3 = this.getOptionalSetting("AutomaticColumnRename", connSettingRequestMap);
        this.m_definedSettings.put("AutomaticColumnRename", true);
        if (null != variant3) {
            try {
                this.m_settings.m_automaticColumnRename = variant3.getInt() == 1;
            }
            catch (Exception exception) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_CONF_ERROR.name(), new String[]{"AutomaticColumnRename", variant3.getString(), "0 , 1"});
                errorException.initCause(exception);
                throw errorException;
            }
        }
        this.m_settings.m_hiveAsyncQueryTest = false;
        variant3 = this.getOptionalSetting("HiveAsyncQueryTest", connSettingRequestMap);
        this.m_definedSettings.put("HiveAsyncQueryTest", true);
        if (null != variant3) {
            try {
                this.m_settings.m_hiveAsyncQueryTest = variant3.getInt() == 1;
            }
            catch (Exception exception) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_CONF_ERROR.name(), new String[]{"HiveAsyncQueryTest", variant3.getString(), "0 , 1"});
                errorException.initCause(exception);
                throw errorException;
            }
        }
        variant3 = this.getOptionalSetting("DelegationToken", connSettingRequestMap);
        this.m_definedSettings.put("DelegationToken", true);
        if (null != variant3) {
            try {
                this.m_settings.m_delegationToken = variant3.getString();
            }
            catch (Exception exception) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_CONF_ERROR.name(), new String[]{"DelegationToken", variant3.getString()});
                errorException.initCause(exception);
                throw errorException;
            }
        }
        variant3 = this.getOptionalSetting("NonSSPs", connSettingRequestMap);
        this.m_definedSettings.put("NonSSPs", true);
        if (null != variant3) {
            try {
                object = variant3.getString();
                String[] stringArray = ((String)object).split(",");
                this.m_settings.m_nonSSPs.addAll(Arrays.asList(stringArray));
            }
            catch (Exception exception) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_CONF_ERROR.name(), new String[]{"NonSSPs", variant3.getString()});
                errorException.initCause(exception);
                throw errorException;
            }
        }
        this.setDriverSpecificSettings();
        if (!this.m_settings.m_fastConnect) {
            boolean bl = false;
            int n4 = this.m_settings.m_timeout;
            int n5 = n * 1000;
            if (0 != n && (0 == this.m_settings.m_timeout || this.m_settings.m_timeout > n5)) {
                bl = true;
                this.m_settings.m_timeout = n5;
            }
            Object object4 = ((HiveJDBCCommonDriver)DSIDriverSingleton.getInstance()).getClientFactory();
            this.m_hiveClient = object4.createClient(this.m_settings, this.m_log, this.getWarningListener());
            this.m_settings.m_timeout = n4;
            if (null == variant && 0 != this.m_settings.m_timeout) {
                this.m_hiveClient.closeSession();
                this.m_settings.m_timeout = 0;
                this.m_hiveClient = object4.createClient(this.m_settings, this.m_log, this.getWarningListener());
            } else if (bl) {
                this.m_hiveClient.closeSession();
                this.m_hiveClient = object4.createClient(this.m_settings, this.m_log, this.getWarningListener());
            }
        } else {
            object = ((HiveJDBCCommonDriver)DSIDriverSingleton.getInstance()).getClientFactory();
            this.m_hiveClient = object.createClient(this.m_settings, this.m_log, this.getWarningListener());
        }
        if (null != variant2) {
            this.m_definedSettings.put("Port", true);
        }
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        Iterator<String> iterator = connSettingRequestMap.getKeysIterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (this.m_definedSettings.containsKey(string) || this.m_settings.m_nonSSPs.contains(string) || string.equals("DriverLocale") || string.equals("LogLevel") || string.equals("LogPath") || string.equals("LogNamespace")) continue;
            treeMap.put(string, connSettingRequestMap.getProperty(string).getString());
        }
        LogUtilities.logDebug(treeMap.toString(), this.m_log);
        for (Object object4 : treeMap.keySet()) {
            String string = "SET " + (String)object4 + "=" + (String)treeMap.get(object4);
            try {
                this.m_hiveClient.executeUpdate(string, null);
            }
            catch (ErrorException errorException) {
                if (null == this.getWarningListener()) continue;
                this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, errorException.getMessageKeyOrText(), errorException.getMessageParams()));
            }
        }
        this.m_settings.m_tableNameColIndex = this.m_settings.m_platformVersionUtils.getTableNameColIndex(this.m_settings.m_serverVersion);
        this.m_settings.m_isTemporaryColIndex = this.m_settings.m_platformVersionUtils.getIsTemporaryColIndex(this.m_settings.m_serverVersion);
        variant3 = this.getOptionalSetting("ShowTablesTableNameColIdx", connSettingRequestMap);
        if (null != variant3) {
            try {
                int n6 = variant3.getInt();
                this.m_settings.m_tableNameColIndex = 0 <= n6 ? n6 : this.m_settings.m_tableNameColIndex;
            }
            catch (Exception exception) {
                this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_SHOW_TABLES_TABLE_NAME_COL_IDX.name()));
            }
        }
        if (null != (variant3 = this.getOptionalSetting("ShowTablesIsTempTableColIdx", connSettingRequestMap))) {
            try {
                int n7 = variant3.getInt();
                this.m_settings.m_isTemporaryColIndex = 0 <= n7 ? n7 : this.m_settings.m_isTemporaryColIndex;
            }
            catch (Exception exception) {
                this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_SHOW_TABLES_IS_TEMP_TABLE_COL_IDX.name()));
            }
        }
    }

    public IHiveClient getClient() {
        return this.m_hiveClient;
    }

    public String getDelegationToken(String string, String string2) throws ErrorException {
        if (this.m_hiveClient instanceof HS2Client) {
            try {
                String string3 = ((HS2Client)this.m_hiveClient).getDelegationToken(string, string2);
                String string4 = string3.replace("=", "").replace("+", "-").replace("/", "_");
                return string4;
            }
            catch (Exception exception) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.GET_DELEGATION_TOKEN_ERR.name(), new String[]{exception.getMessage(), string, string2});
                errorException.initCause(exception);
                throw errorException;
            }
        }
        ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.UNSUPPORTED_OPERATION_ERR.name(), "getDelegationToken");
        throw errorException;
    }

    public IHiveClient getHiveClient() {
        return this.m_hiveClient;
    }

    public abstract IScalarFnMetadataHandler getScalarFnMetadataHandler();

    public HiveJDBCSettings getSettings() {
        return this.m_settings;
    }

    public ExecutorService getThreadPool() {
        return this.m_threadPool;
    }

    @Override
    public void handleException(Exception exception) throws ErrorException {
        Throwable throwable;
        if (null != exception && !(exception instanceof TimeoutException) && null != (throwable = exception.getCause()) && throwable instanceof ErrorException && null != (throwable = throwable.getCause()) && throwable instanceof TTransportException && null != throwable.getCause()) {
            String string;
            if (throwable.getCause() instanceof SocketTimeoutException) {
                ErrorException errorException = new ErrorException(DiagState.DIAG_CONN_TIMEOUT_EXPIRED, 105, CommonJDBCMessageKey.CONN_LOGINTIMEOUT_ERR.name(), new String[]{null != throwable.getMessage() ? throwable.getMessage() : "Unknown"});
                errorException.initCause(throwable);
                throw errorException;
            }
            if (throwable.getCause() instanceof ConnectException && null != (string = throwable.getCause().getMessage()) && string.toLowerCase().contains("connection timed out")) {
                ErrorException errorException = new ErrorException(DiagState.DIAG_CONN_TIMEOUT_EXPIRED, 105, CommonJDBCMessageKey.CONN_LOGINTIMEOUT_ERR.name(), new String[]{null != throwable.getMessage() ? throwable.getMessage() : "Unknown"});
                errorException.initCause(throwable);
                throw errorException;
            }
        }
        super.handleException(exception);
    }

    protected abstract void setImplementationDefaultSettings();

    public void renewDelegationToken(String string) throws ErrorException {
        if (this.m_hiveClient instanceof HS2Client) {
            try {
                ((HS2Client)this.m_hiveClient).renewDelegationToken(string);
            }
            catch (Exception exception) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.RENEW_DELEGATION_TOKEN_ERR.name(), new String[]{exception.getLocalizedMessage(), string});
                errorException.initCause(exception);
                throw errorException;
            }
        } else {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.UNSUPPORTED_OPERATION_ERR.name(), "renewDelegationToken");
            throw errorException;
        }
    }

    @Override
    public String toNativeSQL(String string) {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), string);
        if (!this.m_settings.m_useNativeQuery) {
            HashMap<Character, Character> hashMap = new HashMap<Character, Character>();
            hashMap.put(Character.valueOf('\''), Character.valueOf('\''));
            hashMap.put(Character.valueOf('\"'), Character.valueOf('\"'));
            hashMap.put(Character.valueOf('`'), Character.valueOf('`'));
            return ParseQueryUtils.parseCommentsOnSingleQuery(string, this.m_settings.m_platformVersionUtils.supportsQueryCommentHints(this.m_settings.m_serverVersion), hashMap);
        }
        return string;
    }

    @Override
    public ConnSettingResponseMap updateConnectionSettings(ConnSettingRequestMap connSettingRequestMap) throws ErrorException {
        Object object;
        Variant variant;
        Variant variant2;
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        String string = null;
        LogLevel logLevel = LogLevel.OFF;
        String string2 = "";
        Variant variant3 = this.getOptionalSetting("LogPath", connSettingRequestMap);
        Variant variant4 = this.getOptionalSetting("LogLevel", connSettingRequestMap);
        Variant variant5 = this.getOptionalSetting("LogNamespace", connSettingRequestMap);
        if (null != variant3) {
            string = variant3.getString();
        }
        if (null != variant4) {
            logLevel = LogLevel.getLogLevel(variant4.getString());
        }
        if (null != variant5) {
            string2 = variant5.getString();
        }
        this.createConnectionLog(logLevel, string, string2);
        HiveJDBCSettings hiveJDBCSettings = new HiveJDBCSettings();
        ConnSettingResponseMap connSettingResponseMap = new ConnSettingResponseMap();
        Variant variant6 = this.getOptionalSetting("AuthMech", connSettingRequestMap);
        if (null != variant6) {
            try {
                if (variant6.getInt() < AuthMech.values().length && variant6.getInt() >= 0) {
                    hiveJDBCSettings.m_authMech = AuthMech.values()[variant6.getInt()];
                }
            }
            catch (Exception exception) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_CONF_ERROR.toString(), exception.getMessage());
                errorException.initCause(exception);
                throw errorException;
            }
        }
        if (null != (variant2 = this.getOptionalSetting("HiveServerType", connSettingRequestMap))) {
            try {
                if (1 == variant2.getInt()) {
                    hiveJDBCSettings.m_hiveServerType = HiveServerType.HiveServer1;
                } else if (2 == variant2.getInt()) {
                    hiveJDBCSettings.m_hiveServerType = HiveServerType.HiveServer2;
                }
            }
            catch (Exception exception) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_HIVESERVERTYPE_ERR.name(), exception.getMessage());
                errorException.initCause(exception);
                throw errorException;
            }
        }
        Variant variant7 = this.getOptionalSetting("ssl", connSettingRequestMap);
        this.m_definedSettings.put("ssl", true);
        if (variant7 != null) {
            try {
                boolean bl;
                boolean bl2 = bl = variant7.getInt() == 1;
                hiveJDBCSettings.m_enableSSL = bl;
            }
            catch (Exception exception) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_CONF_ERROR.name(), new String[]{"ssl", variant7.getString(), "0 , 1"});
                errorException.initCause(exception);
                throw errorException;
            }
        }
        if (null != (variant = this.getOptionalSetting("transportMode", connSettingRequestMap))) {
            object = variant.getString();
            hiveJDBCSettings.m_transportMode = ((String)object).equalsIgnoreCase("http") ? TransportMode.HTTP : (((String)object).equalsIgnoreCase("binary") ? TransportMode.BINARY : TransportMode.SASL);
        }
        hiveJDBCSettings.m_dynamicServerDiscovery = null != (object = this.getOptionalSetting("zk", connSettingRequestMap));
        this.verifyRequiredSetting("DatabaseType", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("DefaultStringColumnLength", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("AsyncExecPollInterval", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("RowsFetchedPerBlock", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("AuthMech", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("SocketTimeOut", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("DelegationUID", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("ConnSchema", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("ssl", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("CatalogSchemaSwitch", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("PreparedMetaLimitZero", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("UseNativeQuery", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("UseCustomTypeCoercionMap", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("StripCatalogName", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("AutomaticColumnRename", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("DelegationToken", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("ServerVersion", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("FastConnection", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("NonSSPs", connSettingRequestMap, connSettingResponseMap);
        return this.updateConnectionSettings(hiveJDBCSettings, connSettingRequestMap, connSettingResponseMap);
    }

    public ConnSettingResponseMap updateConnectionSettings(HiveJDBCSettings hiveJDBCSettings, ConnSettingRequestMap connSettingRequestMap, ConnSettingResponseMap connSettingResponseMap) {
        return connSettingResponseMap;
    }

    protected void setDriverSpecificSettings() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createConnectionLog(LogLevel logLevel, String string, String string2) {
        String string3 = this.getConnectionLogFileName();
        Object object = s_loggerLock;
        synchronized (object) {
            if (null == this.m_log) {
                this.m_log = new DSILogger(string3 + Integer.toString(s_connectionID++), logLevel, string, string2);
                this.m_log.setLocale(this.getLocale());
            }
        }
    }

    protected abstract String getConnectionLogFileName();

    protected abstract ProductInfoHandler getProductInfoHandler();

    protected boolean isAuthMechValid(HiveJDBCSettings hiveJDBCSettings) {
        switch (hiveJDBCSettings.m_transportMode) {
            case BINARY: {
                return AuthMech.NOAUTH == hiveJDBCSettings.m_authMech || AuthMech.UIDPWD == hiveJDBCSettings.m_authMech;
            }
            case SASL: {
                return AuthMech.SASL_KERBEROS == hiveJDBCSettings.m_authMech || AuthMech.SASL_PLAIN_UID == hiveJDBCSettings.m_authMech || AuthMech.UIDPWD == hiveJDBCSettings.m_authMech;
            }
            case HTTP: {
                return AuthMech.UIDPWD == hiveJDBCSettings.m_authMech || AuthMech.SASL_KERBEROS == hiveJDBCSettings.m_authMech;
            }
        }
        return false;
    }

    protected void setDefaultProperties() throws ErrorException {
        try {
            this.setProperty(101, new Variant(0, "ImpalaJDBC"));
            this.setProperty(139, new Variant(0, "User"));
            this.setProperty(22, new Variant(0, ((HiveJDBCCommonDriver)DSIDriverSingleton.getInstance()).getCatalogName()));
            this.setProperty(58, new Variant(0, "`"));
            this.setProperty(66, new Variant(2, Character.valueOf('\u0080')));
            this.setProperty(68, new Variant(2, Character.valueOf('\u0080')));
            this.setProperty(76, new Variant(2, Character.valueOf('\u0080')));
            this.setProperty(81, new Variant(2, Character.valueOf('\u0080')));
            this.setProperty(83, new Variant(2, Character.valueOf('\u0080')));
            this.setProperty(80, new Variant(0, "N"));
        }
        catch (Exception exception) {
            throw HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DEFAULT_PROP_SETTING_ERR.name(), exception.getMessage());
        }
    }
}

