/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hivecommon.api;

import com.cloudera.dsi.dataengine.utilities.DSITypeUtilities;
import com.cloudera.dsi.dataengine.utilities.DataWrapper;
import com.cloudera.dsi.exceptions.IncorrectTypeException;
import com.cloudera.dsi.utilities.StringConverter;
import com.cloudera.hivecommon.HiveJDBCSettings;
import com.cloudera.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.hivecommon.dataengine.HiveJDBCQueryAnalyserUtils;
import com.cloudera.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.support.exceptions.ErrorException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Date;
import org.apache.hive.service.cli.thrift.TColumnValue;
import org.apache.hive.service.cli.thrift.TFetchResultsResp;
import org.apache.hive.service.cli.thrift.TRow;

public class HS2Buffer {
    private final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    public TFetchResultsResp m_hiveServer2Buffer = null;

    public int getNumRows() throws ErrorException {
        return this.m_hiveServer2Buffer.getResults().getRowsSize();
    }

    public boolean getData(int n, long l, long l2, DataWrapper dataWrapper, int n2, short s, String string, HiveJDBCSettings hiveJDBCSettings) throws ErrorException {
        TColumnValue tColumnValue = (TColumnValue)((TRow)this.m_hiveServer2Buffer.getResults().getRows().get(n2)).getColVals().get(n);
        switch (s) {
            case -2: {
                if (!tColumnValue.getStringVal().isSetValue()) {
                    dataWrapper.setNull(s);
                    return false;
                }
                String string2 = tColumnValue.getStringVal().getValue();
                if (null == string2) {
                    dataWrapper.setNull(s);
                    return false;
                }
                try {
                    return DSITypeUtilities.outputBytes(string2.getBytes("UTF8"), dataWrapper, l, l2, s);
                }
                catch (IncorrectTypeException incorrectTypeException) {
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_RESULTSET_DATA_RETRIEVING_ERR.name(), new String[]{"Data Type May Not Supported"});
                    throw errorException;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_RESULTSET_DATA_RETRIEVING_ERR.name(), new String[]{"Data Type May Not Supported"});
                    throw errorException;
                }
            }
            case 1: {
                dataWrapper.setChar(tColumnValue.getStringVal().getValue());
                return false;
            }
            case 12: {
                if (!tColumnValue.getStringVal().isSetValue()) {
                    dataWrapper.setNull(s);
                    return false;
                }
                String string3 = tColumnValue.getStringVal().getValue();
                if (null == string3) {
                    dataWrapper.setNull(s);
                    return false;
                }
                if (HiveJDBCQueryAnalyserUtils.queryAnalysis(string).equalsIgnoreCase("DESCRIBE")) {
                    return DSITypeUtilities.outputVarCharStringData(string3.trim(), dataWrapper, l, l2);
                }
                return DSITypeUtilities.outputVarCharStringData(string3, dataWrapper, l, l2);
            }
            case 16: {
                if (!tColumnValue.getBoolVal().isSetValue()) {
                    dataWrapper.setNull(s);
                    return false;
                }
                dataWrapper.setBoolean(tColumnValue.getBoolVal().isValue());
                return false;
            }
            case -6: {
                if (!tColumnValue.getByteVal().isSetValue()) {
                    dataWrapper.setNull(s);
                    return false;
                }
                dataWrapper.setTinyInt(tColumnValue.getByteVal().getValue());
                return false;
            }
            case 5: {
                if (hiveJDBCSettings.m_platformVersionUtils.supportI16BufferForSmallInt(hiveJDBCSettings.m_serverVersion)) {
                    if (!tColumnValue.getI16Val().isSetValue()) {
                        dataWrapper.setNull(s);
                        return false;
                    }
                    dataWrapper.setSmallInt(tColumnValue.getI16Val().getValue());
                    return false;
                }
                if (!tColumnValue.getI32Val().isSetValue()) {
                    dataWrapper.setNull(s);
                    return false;
                }
                dataWrapper.setSmallInt((short)tColumnValue.getI32Val().getValue());
                return false;
            }
            case 4: {
                if (!tColumnValue.getI32Val().isSetValue()) {
                    dataWrapper.setNull(s);
                    return false;
                }
                dataWrapper.setInteger(tColumnValue.getI32Val().getValue());
                return false;
            }
            case -5: {
                if (!tColumnValue.getI64Val().isSetValue()) {
                    dataWrapper.setNull(s);
                    return false;
                }
                dataWrapper.setInteger(tColumnValue.getI64Val().getValue());
                return false;
            }
            case 7: {
                if (!tColumnValue.getDoubleVal().isSetValue()) {
                    dataWrapper.setNull(s);
                    return false;
                }
                dataWrapper.setReal((float)tColumnValue.getDoubleVal().getValue());
                return false;
            }
            case 8: {
                if (!tColumnValue.getDoubleVal().isSetValue()) {
                    dataWrapper.setNull(s);
                    return false;
                }
                dataWrapper.setDouble(tColumnValue.getDoubleVal().getValue());
                return false;
            }
            case 93: {
                if (!tColumnValue.getStringVal().isSetValue() || tColumnValue.getStringVal().getValue() == null) {
                    dataWrapper.setNull(s);
                    return false;
                }
                dataWrapper.setTimestamp(StringConverter.parseTimestamp(tColumnValue.getStringVal().getValue(), null));
                return false;
            }
            case 3: {
                if (!tColumnValue.getStringVal().isSetValue() || tColumnValue.getStringVal().getValue() == null) {
                    dataWrapper.setNull(s);
                    return false;
                }
                dataWrapper.setDecimal(new BigDecimal(tColumnValue.getStringVal().getValue()));
                return false;
            }
            case 91: {
                if (!tColumnValue.getStringVal().isSetValue() || tColumnValue.getStringVal().getValue() == null) {
                    dataWrapper.setNull(s);
                    return false;
                }
                dataWrapper.setDate(Date.valueOf(tColumnValue.getStringVal().getValue()));
                return false;
            }
        }
        ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_RESULTSET_DATA_RETRIEVING_ERR.name(), new String[]{"Data Type May Not Supported"});
        throw errorException;
    }

    public String getString(int n, int n2) throws Exception {
        return ((TColumnValue)((TRow)this.m_hiveServer2Buffer.getResults().getRows().get(n)).getColVals().get(n2)).getStringVal().getValue();
    }
}

