/*
 * Decompiled with CFR 0.152.
 */
package org.opengauss.jdbc;

import java.sql.SQLException;
import java.sql.Struct;
import java.util.List;
import java.util.Map;
import org.opengauss.Driver;
import org.opengauss.core.BaseConnection;
import org.opengauss.core.TypeInfo;
import org.opengauss.jdbc.PGStructAttrsConverter;
import org.opengauss.util.PGobject;

public class PGStruct
extends PGobject
implements Struct {
    private int oid;
    protected BaseConnection conn;
    private List<Integer> attrsSqlTypeList;
    boolean standardConformingStrings;

    public PGStruct(BaseConnection conn, int oid, String attrsValue) throws SQLException {
        this.conn = conn;
        this.oid = oid;
        this.type = conn.getTypeInfo().getPGType(oid);
        this.value = attrsValue;
        this.attrsSqlTypeList = this.getAttrsSqlTypeList();
        this.standardConformingStrings = conn.getStandardConformingStrings();
    }

    public PGStruct(BaseConnection conn, int oid, Object[] attributes) throws SQLException {
        this.oid = oid;
        this.conn = conn;
        this.standardConformingStrings = conn.getStandardConformingStrings();
        this.type = conn.getTypeInfo().getPGType(oid);
        this.value = PGStructAttrsConverter.convertAttributes(attributes);
        this.attrsSqlTypeList = this.getAttrsSqlTypeList();
    }

    public int getOid() {
        return this.oid;
    }

    public void setAttrsSqlTypeList(List<Integer> attrsSqlTypeList) {
        this.attrsSqlTypeList = attrsSqlTypeList;
    }

    private List<Integer> getAttrsSqlTypeList() throws SQLException {
        TypeInfo typeInfo = this.conn.getTypeInfo();
        return typeInfo.getStructAttributesOid(this.oid);
    }

    @Override
    public String getSQLTypeName() throws SQLException {
        return this.type;
    }

    @Override
    public Object[] getAttributes() throws SQLException {
        if (this.attrsSqlTypeList == null) {
            this.attrsSqlTypeList = this.getAttrsSqlTypeList();
        }
        return PGStructAttrsConverter.parseAttributes(this.conn, this.attrsSqlTypeList, this.value);
    }

    @Override
    public Object[] getAttributes(Map<String, Class<?>> map) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getAttributes(Map)");
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PGStruct)) {
            return false;
        }
        PGStruct tmp = (PGStruct)obj;
        boolean result = this.toString().equals(tmp.toString());
        if (!result) {
            return false;
        }
        if (this.standardConformingStrings != tmp.standardConformingStrings) {
            return false;
        }
        if (this.type != null && !this.type.equals(tmp.type)) {
            return false;
        }
        return tmp.type == null || tmp.type.equals(this.type);
    }

    @Override
    public int hashCode() {
        int hash = 13;
        hash = 53 * hash + (this.standardConformingStrings ? 1 : 0);
        hash = 53 * hash + (this.type != null ? this.type.hashCode() : 0);
        hash = 53 * hash + (this.value != null ? this.value.hashCode() : 0);
        return hash;
    }

    @Override
    public String toString() {
        if (this.value == null) {
            return "NULL";
        }
        return this.value;
    }
}

