/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DBError;
import dm.jdbc.util.StringUtil;
import java.io.Serializable;
import java.sql.SQLException;

public class DmdbBFile
implements Serializable {
    private static final long serialVersionUID = 6324763666783931674L;
    private String dir;
    private String fileName;
    private String fileId;

    public DmdbBFile(String fullName) throws SQLException {
        String[] strs;
        if (!DmdbBFile.isValidBFileStr(fullName)) {
            DBError.ECJDBC_INVALID_BFILE.throwz(new Object[0]);
        }
        if ((strs = fullName.split(":")).length > 2) {
            this.init(strs[0], strs[1], strs[2]);
        } else {
            this.init(strs[0], strs[1], null);
        }
    }

    public DmdbBFile(String dir, String fileName) throws SQLException {
        new DmdbBFile(String.valueOf(dir) + ":" + fileName);
    }

    protected void init(String dir, String fileName, String fileId) throws SQLException {
        this.dir = dir;
        this.fileName = fileName;
        this.fileId = fileId;
    }

    public static boolean isValidBFileStr(String str) {
        if (StringUtil.isEmpty(str = str.trim())) {
            return false;
        }
        String[] strs = str.split(":");
        return strs.length >= 2 && strs.length <= 3 && strs[0].length() <= 128 && strs[1].length() <= 256;
    }

    public String getFileId() {
        return this.fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public String getDir() {
        return this.dir;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFullName() {
        if (this.isNull()) {
            return "";
        }
        if (StringUtil.isNotEmpty(this.fileId)) {
            return String.valueOf(this.getDir()) + ":" + this.getFileName() + ":" + this.fileId;
        }
        return String.valueOf(this.getDir()) + ":" + this.getFileName();
    }

    public boolean isNull() {
        return StringUtil.isEmpty(this.dir) || StringUtil.isEmpty(this.fileName);
    }

    public String toString() {
        return this.getFullName();
    }
}

