/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqlengine.executor.etree.util;

import com.cloudera.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.cloudera.sqlengine.utilities.SQLEngineMessageKey;
import com.cloudera.support.IWarningListener;
import com.cloudera.support.Warning;
import com.cloudera.support.WarningCode;
import com.cloudera.support.exceptions.ErrorException;

public class DataRetrievalUtil {
    public static boolean retrieveBinaryData(ISqlDataWrapper iSqlDataWrapper, long l, long l2) throws ErrorException {
        return DataRetrievalUtil.retrieveBinaryData(iSqlDataWrapper, l, l2, Long.MAX_VALUE, null);
    }

    public static boolean retrieveCharData(ISqlDataWrapper iSqlDataWrapper, long l, long l2) throws ErrorException {
        return DataRetrievalUtil.retrieveCharData(iSqlDataWrapper, l, l2, Long.MAX_VALUE, null);
    }

    public static boolean retrieveBinaryData(ISqlDataWrapper iSqlDataWrapper, long l, long l2, long l3, IWarningListener iWarningListener) throws ErrorException {
        boolean bl;
        int n;
        byte[] byArray = iSqlDataWrapper.getBinary();
        if (l != 0L && (l >= (long)byArray.length || l >= l3)) {
            throw new IllegalArgumentException("Invalid offset: " + l);
        }
        int n2 = l2 == -1L || l2 > Long.MAX_VALUE - l || (long)byArray.length <= l2 + l ? byArray.length : (int)(l2 + l);
        if (l == 0L && (long)byArray.length <= l2 && (long)byArray.length <= l3) {
            return false;
        }
        int n3 = (int)Math.min((long)n2, l3);
        byte[] byArray2 = new byte[(int)((long)n3 - l)];
        for (n = 0; n < byArray2.length; ++n) {
            byArray2[n] = byArray[(int)((long)n + l)];
        }
        iSqlDataWrapper.setBinary(byArray2);
        n = l3 < (long)n2 ? 1 : 0;
        boolean bl2 = bl = n == 0 && n3 < byArray.length;
        if (iWarningListener != null && n != 0) {
            iWarningListener.postWarning(new Warning(WarningCode.STRING_RIGHT_TRUNCATION_WARNING, 7, SQLEngineMessageKey.STRING_RIGHT_TRUNCATION.name(), -1, -1));
        }
        return bl;
    }

    public static boolean retrieveCharData(ISqlDataWrapper iSqlDataWrapper, long l, long l2, long l3, IWarningListener iWarningListener) throws ErrorException {
        boolean bl;
        if (l % 2L == 1L) {
            throw new IllegalStateException("Invalid offset value: " + l);
        }
        String string = iSqlDataWrapper.getChar();
        int n = string.length();
        if ((l /= 2L) != 0L && (l >= (long)n || l >= l3)) {
            throw new IllegalArgumentException("invalid offset: " + l);
        }
        int n2 = l2 == -1L || l2 / 2L > Long.MAX_VALUE - l || (long)n <= l2 / 2L + l ? n : (int)(l + l2 / 2L);
        if (l == 0L && n == n2 && (long)n <= l3) {
            return false;
        }
        int n3 = (int)Math.min(l3, (long)n2);
        iSqlDataWrapper.setChar(string.substring((int)l, n3));
        boolean bl2 = l3 < (long)n2;
        boolean bl3 = bl = !bl2 && n3 < n;
        if (iWarningListener != null && bl2) {
            iWarningListener.postWarning(new Warning(WarningCode.STRING_RIGHT_TRUNCATION_WARNING, 7, SQLEngineMessageKey.STRING_RIGHT_TRUNCATION.name(), -1, -1));
        }
        return bl;
    }
}

