/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.EnumSet;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.OperationLog;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationHandle;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.OperationStatus;
import org.apache.hive.service.cli.OperationType;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.session.HiveSession;
import org.apache.hive.service.cli.thrift.TProtocolVersion;

public abstract class Operation {
    protected final HiveSession parentSession;
    private OperationState state = OperationState.INITIALIZED;
    private final OperationHandle opHandle;
    private HiveConf configuration;
    public static final Log LOG = LogFactory.getLog((String)Operation.class.getName());
    public static final FetchOrientation DEFAULT_FETCH_ORIENTATION = FetchOrientation.FETCH_NEXT;
    public static final long DEFAULT_FETCH_MAX_ROWS = 100L;
    protected boolean hasResultSet;
    protected volatile HiveSQLException operationException;
    protected final boolean runAsync;
    protected volatile Future<?> backgroundHandle;
    protected OperationLog operationLog;
    protected boolean isOperationLogEnabled;
    private long operationTimeout;
    private long lastAccessTime;
    protected static final EnumSet<FetchOrientation> DEFAULT_FETCH_ORIENTATION_SET = EnumSet.of(FetchOrientation.FETCH_NEXT, FetchOrientation.FETCH_FIRST);

    protected Operation(HiveSession parentSession, OperationType opType, boolean runInBackground) {
        this.parentSession = parentSession;
        this.runAsync = runInBackground;
        this.opHandle = new OperationHandle(opType, parentSession.getProtocolVersion());
        this.lastAccessTime = System.currentTimeMillis();
        this.operationTimeout = HiveConf.getTimeVar((Configuration)parentSession.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_IDLE_OPERATION_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public Future<?> getBackgroundHandle() {
        return this.backgroundHandle;
    }

    protected void setBackgroundHandle(Future<?> backgroundHandle) {
        this.backgroundHandle = backgroundHandle;
    }

    public boolean shouldRunAsync() {
        return this.runAsync;
    }

    public void setConfiguration(HiveConf configuration) {
        this.configuration = new HiveConf(configuration);
    }

    public HiveConf getConfiguration() {
        return new HiveConf(this.configuration);
    }

    public HiveSession getParentSession() {
        return this.parentSession;
    }

    public OperationHandle getHandle() {
        return this.opHandle;
    }

    public TProtocolVersion getProtocolVersion() {
        return this.opHandle.getProtocolVersion();
    }

    public OperationType getType() {
        return this.opHandle.getOperationType();
    }

    public OperationStatus getStatus() {
        return new OperationStatus(this.state, this.operationException);
    }

    public boolean hasResultSet() {
        return this.hasResultSet;
    }

    protected void setHasResultSet(boolean hasResultSet) {
        this.hasResultSet = hasResultSet;
        this.opHandle.setHasResultSet(hasResultSet);
    }

    public OperationLog getOperationLog() {
        return this.operationLog;
    }

    protected final OperationState setState(OperationState newState) throws HiveSQLException {
        this.state.validateTransition(newState);
        this.state = newState;
        this.lastAccessTime = System.currentTimeMillis();
        return this.state;
    }

    public boolean isTimedOut(long current) {
        if (this.operationTimeout == 0L) {
            return false;
        }
        if (this.operationTimeout > 0L) {
            return this.state.isTerminal() && this.lastAccessTime + this.operationTimeout <= current;
        }
        return this.lastAccessTime + -this.operationTimeout <= current;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public long getOperationTimeout() {
        return this.operationTimeout;
    }

    public void setOperationTimeout(long operationTimeout) {
        this.operationTimeout = operationTimeout;
    }

    protected void setOperationException(HiveSQLException operationException) {
        this.operationException = operationException;
    }

    protected final void assertState(OperationState state) throws HiveSQLException {
        if (this.state != state) {
            throw new HiveSQLException("Expected state " + (Object)((Object)state) + ", but found " + (Object)((Object)this.state));
        }
        this.lastAccessTime = System.currentTimeMillis();
    }

    public boolean isRunning() {
        return OperationState.RUNNING.equals((Object)this.state);
    }

    public boolean isFinished() {
        return OperationState.FINISHED.equals((Object)this.state);
    }

    public boolean isCanceled() {
        return OperationState.CANCELED.equals((Object)this.state);
    }

    public boolean isFailed() {
        return OperationState.ERROR.equals((Object)this.state);
    }

    protected void createOperationLog() {
        if (this.parentSession.isOperationLogEnabled()) {
            File operationLogFile = new File(this.parentSession.getOperationLogSessionDir(), this.opHandle.getHandleIdentifier().toString());
            this.isOperationLogEnabled = true;
            try {
                if (operationLogFile.exists()) {
                    LOG.warn((Object)("The operation log file should not exist, but it is already there: " + operationLogFile.getAbsolutePath()));
                    operationLogFile.delete();
                }
                if (!(operationLogFile.createNewFile() || operationLogFile.canRead() && operationLogFile.canWrite())) {
                    LOG.warn((Object)("The already existed operation log file cannot be recreated, and it cannot be read or written: " + operationLogFile.getAbsolutePath()));
                    this.isOperationLogEnabled = false;
                    return;
                }
            }
            catch (Exception e) {
                LOG.warn((Object)("Unable to create operation log file: " + operationLogFile.getAbsolutePath()), (Throwable)e);
                this.isOperationLogEnabled = false;
                return;
            }
            try {
                this.operationLog = new OperationLog(this.opHandle.toString(), operationLogFile, this.parentSession.getHiveConf());
            }
            catch (FileNotFoundException e) {
                LOG.warn((Object)("Unable to instantiate OperationLog object for operation: " + this.opHandle), (Throwable)e);
                this.isOperationLogEnabled = false;
                return;
            }
            OperationLog.setCurrentOperationLog((OperationLog)this.operationLog);
        }
    }

    protected void unregisterOperationLog() {
        if (this.isOperationLogEnabled) {
            OperationLog.removeCurrentOperationLog();
        }
    }

    protected void beforeRun() {
        this.createOperationLog();
    }

    protected void afterRun() {
        this.unregisterOperationLog();
    }

    protected abstract void runInternal() throws HiveSQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws HiveSQLException {
        this.beforeRun();
        try {
            this.runInternal();
        }
        finally {
            this.afterRun();
        }
    }

    protected void cleanupOperationLog() {
        if (this.isOperationLogEnabled) {
            if (this.operationLog == null) {
                LOG.error((Object)("Operation [ " + this.opHandle.getHandleIdentifier() + " ] " + "logging is enabled, but its OperationLog object cannot be found."));
            } else {
                this.operationLog.close();
            }
        }
    }

    public void cancel() throws HiveSQLException {
        this.setState(OperationState.CANCELED);
        throw new UnsupportedOperationException("SQLOperation.cancel()");
    }

    public abstract void close() throws HiveSQLException;

    public abstract TableSchema getResultSetSchema() throws HiveSQLException;

    public abstract RowSet getNextRowSet(FetchOrientation var1, long var2) throws HiveSQLException;

    public RowSet getNextRowSet() throws HiveSQLException {
        return this.getNextRowSet(FetchOrientation.FETCH_NEXT, 100L);
    }

    protected void validateDefaultFetchOrientation(FetchOrientation orientation) throws HiveSQLException {
        this.validateFetchOrientation(orientation, DEFAULT_FETCH_ORIENTATION_SET);
    }

    protected void validateFetchOrientation(FetchOrientation orientation, EnumSet<FetchOrientation> supportedOrientations) throws HiveSQLException {
        if (!supportedOrientations.contains((Object)orientation)) {
            throw new HiveSQLException("The fetch type " + orientation.toString() + " is not supported for this resultset", "HY106");
        }
    }

    protected HiveSQLException toSQLException(String prefix, CommandProcessorResponse response) {
        HiveSQLException ex = new HiveSQLException(prefix + ": " + response.getErrorMessage(), response.getSQLState(), response.getResponseCode());
        if (response.getException() != null) {
            ex.initCause(response.getException());
        }
        return ex;
    }
}

