/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.jdbc.jdbc41;

import com.cloudera.dsi.core.interfaces.IStatement;
import com.cloudera.dsi.dataengine.impl.DSIEmptyResultSet;
import com.cloudera.dsi.dataengine.interfaces.IColumn;
import com.cloudera.dsi.dataengine.interfaces.IResultSet;
import com.cloudera.dsi.dataengine.utilities.ExecutionResult;
import com.cloudera.dsi.dataengine.utilities.ExecutionResultType;
import com.cloudera.dsi.dataengine.utilities.ExecutionResults;
import com.cloudera.exceptions.ExceptionConverter;
import com.cloudera.exceptions.JDBCMessageKey;
import com.cloudera.jdbc.common.SConnection;
import com.cloudera.jdbc.common.SForwardResultSet;
import com.cloudera.jdbc.common4.C4SCallableStatement;
import com.cloudera.jdbc.jdbc41.S41ForwardResultSet;
import com.cloudera.jdbc.jdbc41.S41ParameterMetaData;
import com.cloudera.jdbc.jdbc41.S41ResultSetMetaData;
import com.cloudera.jdbc.jdbc41.S41UpdatableForwardResultSet;
import com.cloudera.support.IWarningListener;
import com.cloudera.support.LogUtilities;
import com.cloudera.support.exceptions.ExceptionType;
import com.cloudera.utilities.JDBCVersion;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;

public class S41CallableStatement
extends C4SCallableStatement {
    public S41CallableStatement(String string, IStatement iStatement, SConnection sConnection, int n) throws SQLException {
        super(string, iStatement, sConnection, n);
        this.m_jdbcVersion = JDBCVersion.JDBC41;
    }

    @Override
    protected ResultSet createResultSet(ExecutionResult executionResult) throws SQLException {
        SForwardResultSet sForwardResultSet = null;
        sForwardResultSet = this.createsUpdatableResults() ? new S41UpdatableForwardResultSet(this, (IResultSet)executionResult.getResult(), this.getLogger()) : new S41ForwardResultSet(this, (IResultSet)executionResult.getResult(), this.getLogger());
        sForwardResultSet.setFetchSize(this.getFetchSize());
        return sForwardResultSet;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            S41ForwardResultSet s41ForwardResultSet = null;
            s41ForwardResultSet = new S41ForwardResultSet(this, new DSIEmptyResultSet(), this.getLogger());
            return s41ForwardResultSet;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            if (null == this.getResultSetMetaData()) {
                ExecutionResults executionResults = this.getQueryExecutor().getResults();
                Iterator<ExecutionResult> iterator = executionResults.getResultItr();
                if (!iterator.hasNext()) {
                    return null;
                }
                ExecutionResult executionResult = iterator.next();
                if (iterator.hasNext()) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_NUMBER_METADATA, (IWarningListener)this.getWarningListener(), ExceptionType.DEFAULT, new Object[0]);
                }
                if (ExecutionResultType.RESULT_SET == executionResult.getType()) {
                    IResultSet iResultSet = (IResultSet)executionResult.getResult();
                    ArrayList<? extends IColumn> arrayList = iResultSet.getSelectColumns();
                    if (null == arrayList) {
                        return null;
                    }
                    S41ResultSetMetaData s41ResultSetMetaData = null;
                    s41ResultSetMetaData = new S41ResultSetMetaData(arrayList, this.getLogger(), this.getWarningListener());
                    this.setResultSetMetadata(s41ResultSetMetaData);
                }
            }
            return this.getResultSetMetaData();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public synchronized ParameterMetaData getParameterMetaData() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            if (null == this.getOpenParamMetaData()) {
                S41ParameterMetaData s41ParameterMetaData = null;
                s41ParameterMetaData = new S41ParameterMetaData(this.getParameterMetadataList(), this.getLogger(), this.getWarningListener());
                this.setOpenParamMetaData(s41ParameterMetaData);
            }
            return this.getOpenParamMetaData();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public synchronized <T> T getObject(int n, Class<T> clazz) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, clazz);
            this.checkIfOpen();
            if (clazz.equals(BigDecimal.class)) {
                return (T)this.getBigDecimal(n);
            }
            if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
                return (T)Boolean.valueOf(this.getBoolean(n));
            }
            if (clazz.equals(Byte.class) || clazz.equals(Byte.TYPE)) {
                return (T)Byte.valueOf(this.getByte(n));
            }
            if (clazz.equals(byte[].class)) {
                return (T)this.getBytes(n);
            }
            if (clazz.equals(Date.class)) {
                return (T)this.getDate(n);
            }
            if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
                return (T)Double.valueOf(this.getDouble(n));
            }
            if (clazz.equals(Float.class) || clazz.equals(Float.TYPE)) {
                return (T)Float.valueOf(this.getFloat(n));
            }
            if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
                return (T)Integer.valueOf(this.getInt(n));
            }
            if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
                return (T)Long.valueOf(this.getLong(n));
            }
            if (clazz.equals(Object.class)) {
                return (T)this.getObject(n);
            }
            if (clazz.equals(Short.class) || clazz.equals(Short.TYPE)) {
                return (T)Short.valueOf(this.getShort(n));
            }
            if (clazz.equals(String.class)) {
                return (T)this.getString(n);
            }
            if (clazz.equals(Time.class)) {
                return (T)this.getTime(n);
            }
            if (clazz.equals(Timestamp.class)) {
                return (T)this.getTimestamp(n);
            }
            if (clazz.equals(Array.class) || clazz.equals(Blob.class) || clazz.equals(Clob.class) || clazz.equals(Ref.class) || clazz.equals(URL.class) || clazz.equals(NClob.class) || clazz.equals(RowId.class) || clazz.equals(SQLXML.class)) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, String.valueOf(n), clazz.getName());
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public <T> T getObject(String string, Class<T> clazz) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, clazz);
        return this.getObject(this.getParameterIndex(string), clazz);
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            this.m_closeOnCompletion = true;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            return this.m_closeOnCompletion;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }
}

