/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util.buffer;

import dm.jdbc.util.ByteUtil;
import dm.jdbc.util.buffer.BufferNode;
import dm.jdbc.util.buffer.ByteArrayNode;
import dm.jdbc.util.buffer.ByteBufferNode;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;

public class Buffer {
    public static final int TYPE_ARRAY = 0;
    public static final int TYPE_HEAP = 1;
    public static final int TYPE_DIRECT = 2;
    private boolean adaptive;
    private int bufferType;
    private int count;
    private BufferNode<?> current;
    private BufferNode<?> first;
    private BufferNode<?> last;

    public static final Buffer allocate(int capacity, boolean adaptive, int bufferType) {
        return new Buffer(capacity, adaptive, bufferType);
    }

    public static final Buffer wrap(byte[] bytes, boolean adaptive, int bufferType) {
        return Buffer.wrap(bytes, 0, bytes.length, adaptive, bufferType);
    }

    public static final Buffer wrap(byte[] bytes, int offset, int length, boolean adaptive, int bufferType) {
        return new Buffer(bytes, offset, length, adaptive, bufferType);
    }

    Buffer(int capacity, boolean adaptive, int bufferType) {
        this.adaptive = adaptive;
        this.bufferType = bufferType;
        this.count = 1;
        this.current = bufferType == 0 ? new ByteArrayNode(capacity) : new ByteBufferNode(capacity, bufferType == 2);
        this.last = this.current;
        this.first = this.last;
    }

    Buffer(byte[] bytes, int offset, int length, boolean adaptive, int bufferType) {
        this.adaptive = adaptive;
        this.bufferType = bufferType;
        this.count = 1;
        this.current = bufferType == 0 ? new ByteArrayNode(bytes, offset, length) : new ByteBufferNode(bytes, offset, length);
        this.last = this.current;
        this.first = this.last;
    }

    public String toString() {
        StringBuilder str = new StringBuilder("[" + this.count + "]: ");
        BufferNode<?> node = this.first;
        while (node != null) {
            if (node != this.first) {
                str.append(" <-> ");
            }
            if (node == this.current) {
                str.append("*");
            }
            str.append("{");
            str.append(node);
            str.append("}");
            node = node.next;
        }
        return str.toString();
    }

    public static void main(String[] args) {
        Charset encoding = Charset.forName("utf-8");
        Buffer buffer = Buffer.allocate(4, true, 2);
        byte[] byArray = new byte[5];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byArray[4] = 4;
        byte[] bytes = byArray;
        buffer.writeBytes(bytes);
        System.out.println(buffer);
        buffer.writeInt(123);
        System.out.println(buffer);
        buffer.writeStringWithNTS("just for test", encoding);
        buffer.rewind(0);
        System.out.println(buffer);
        System.out.println(Arrays.toString(buffer.readBytes(bytes.length)));
        System.out.println(buffer.readInt());
        System.out.println(buffer.readStringWithNTS(encoding));
        System.out.println(buffer);
        System.out.println(buffer.length());
        buffer.clear(5);
        System.out.println(buffer);
        System.out.println(buffer.length());
        System.out.println(buffer.offset(true));
        System.out.println(buffer.offset(false));
        buffer.clear(0);
        System.out.println(buffer);
        buffer.writeStringWithNTS("JUST FOR TEST...", encoding);
        System.out.println(buffer);
        buffer.rewind(0);
        System.out.println(buffer.readStringWithNTS(encoding));
        buffer.replace(0, 4, "jut".getBytes());
        System.out.println(buffer);
        buffer.rewind(0);
        System.out.println(buffer.readStringWithNTS(encoding));
    }

    public int capacity() {
        if (this.adaptive) {
            return Integer.MAX_VALUE;
        }
        int capacity = 0;
        BufferNode<?> node = this.first;
        while (node != null) {
            capacity += node.capacity();
            node = node.next;
        }
        return capacity;
    }

    public int length() {
        int length = 0;
        BufferNode<?> node = this.first;
        while (node != null) {
            length += node.length(true);
            node = node.next;
        }
        return length;
    }

    public Buffer clear(int offset) {
        BufferNode<?> node = this.locate(offset);
        node.clear(node.extra);
        this.current = node;
        node = node.next;
        while (node != null) {
            node.clear(0);
            node = node.next;
        }
        return this;
    }

    public Buffer rewind(int offset) {
        BufferNode<?> node = this.locate(offset);
        node.rewind(node.extra);
        this.current = node;
        node = this.first;
        while (node != this.current) {
            node.rewind(node.write);
            node = node.next;
        }
        node = this.current.next;
        while (node != null) {
            node.rewind(0);
            node = node.next;
        }
        return this;
    }

    public int offset(boolean forWrite) {
        int offset = this.current.offset(forWrite);
        BufferNode<?> node = this.first;
        while (node != this.current) {
            offset += node.capacity();
            node = node.next;
        }
        return offset;
    }

    public int available(boolean forWrite) {
        if (!forWrite) {
            int available = 0;
            BufferNode<?> node = this.current;
            while (node != null) {
                available += node.available(false);
                node = node.next;
            }
            return available;
        }
        return this.adaptive ? Integer.MAX_VALUE : this.current.available(true);
    }

    public Buffer skip(int length, boolean forWrite, boolean forward) {
        while (length > 0) {
            if ((length -= this.current.skip(length, forWrite, forward)) == 0) break;
            BufferNode<?> bufferNode = this.current = forward ? this.current.next : this.current.prev;
            if (this.current != null) continue;
            if (forWrite && this.adaptive) {
                this.extend(length);
                continue;
            }
            throw new RuntimeException("index out of range");
        }
        return this;
    }

    public Buffer insert(int offset, byte[] bytes) {
        return this.replace(offset, 0, bytes);
    }

    public Buffer replace(int offset, int length, byte[] bytes) {
        int tlength = this.length();
        this.rewind(offset + length);
        byte[] rewriteBytes = this.readBytes(tlength - offset - length);
        this.clear(offset);
        this.writeBytes(bytes);
        this.writeBytes(rewriteBytes);
        return this;
    }

    public int load(Object object, int len, boolean fully) throws IOException {
        int total = 0;
        while (len > 0) {
            int llen = this.current.load(object, len, fully);
            total += llen;
            if ((len -= llen) == 0) break;
            this.current = this.current.next;
            if (this.current != null) continue;
            if (this.adaptive) {
                this.extend(len);
                continue;
            }
            throw new RuntimeException("index out of range");
        }
        return total;
    }

    public int flush(Object channel, boolean fully) throws IOException {
        int total = 0;
        BufferNode<?> node = this.first;
        do {
            total += node.flush(channel, fully);
        } while ((node = node.next) != null);
        if (this.bufferType == 0) {
            ((OutputStream)channel).flush();
        }
        return total;
    }

    private void extend(int capacity) {
        int maybe = 2 * this.last.capacity();
        int n2 = capacity = capacity > maybe ? capacity : maybe;
        this.current = this.bufferType == 0 ? new ByteArrayNode(capacity) : new ByteBufferNode(capacity, this.bufferType == 2);
        this.current.prev = this.last;
        this.last.next = this.current;
        this.last = this.current;
        ++this.count;
    }

    private BufferNode<?> locate(int offset) {
        BufferNode<?> node = this.first;
        while (node != null) {
            int skip = node.capacity();
            if (offset < skip) break;
            offset -= skip;
            node = node.next;
        }
        if (node == null) {
            throw new RuntimeException("index out of range");
        }
        node.extra = offset;
        return node;
    }

    public int writeByte(byte b2) {
        if (this.current.available(true) >= 1) {
            return this.current.writeByte(b2);
        }
        return this.writeBytes(ByteUtil.fromByte(b2));
    }

    public int writeShort(short s2) {
        if (this.current.available(true) >= 2) {
            return this.current.writeShort(s2);
        }
        return this.writeBytes(ByteUtil.fromShort(s2));
    }

    public int writeInt(int i2) {
        if (this.current.available(true) >= 4) {
            return this.current.writeInt(i2);
        }
        return this.writeBytes(ByteUtil.fromInt(i2));
    }

    public int writeUB1(int i2) {
        if (this.current.available(true) >= 1) {
            return this.current.writeUB1(i2);
        }
        return this.writeBytes(ByteUtil.fromUB1(i2));
    }

    public int writeUB2(int i2) {
        if (this.current.available(true) >= 2) {
            return this.current.writeUB2(i2);
        }
        return this.writeBytes(ByteUtil.fromUB2(i2));
    }

    public int writeUB3(int i2) {
        return this.writeBytes(ByteUtil.fromUB3(i2));
    }

    public int writeUB4(long l2) {
        if (this.current.available(true) >= 4) {
            return this.current.writeUB4(l2);
        }
        return this.writeBytes(ByteUtil.fromUB4(l2));
    }

    public int writeLong(long l2) {
        if (this.current.available(true) >= 8) {
            return this.current.writeLong(l2);
        }
        return this.writeBytes(ByteUtil.fromLong(l2));
    }

    public int writeFloat(float f2) {
        if (this.current.available(true) >= 4) {
            return this.current.writeFloat(f2);
        }
        return this.writeBytes(ByteUtil.fromFloat(f2));
    }

    public int writeDouble(double d2) {
        if (this.current.available(true) >= 8) {
            return this.current.writeDouble(d2);
        }
        return this.writeBytes(ByteUtil.fromDouble(d2));
    }

    public int writeBytes(byte[] bytes) {
        return this.writeBytes(bytes, 0, bytes.length);
    }

    public int writeBytes(byte[] bytes, int offset, int len) {
        int orgLen = len;
        while (len > 0) {
            int wlen;
            int available = this.current.available(true);
            if ((len -= (wlen = this.current.writeBytes(bytes, offset, available < len ? available : len))) <= 0) break;
            this.current = this.current.next;
            if (this.current == null) {
                if (this.adaptive) {
                    this.extend(len);
                } else {
                    throw new RuntimeException("index out of range");
                }
            }
            offset += wlen;
        }
        return orgLen;
    }

    public int writeBytesWithLength(byte[] bytes) {
        return this.writeBytesWithLength(bytes, 0, bytes.length);
    }

    public int writeBytesWithLength(byte[] bytes, int offset, int len) {
        return this.writeInt(len) + this.writeBytes(bytes, offset, len);
    }

    public int writeBytesWithLength1(byte[] bytes) {
        return this.writeBytesWithLength1(bytes, 0, bytes.length);
    }

    public int writeBytesWithLength1(byte[] bytes, int offset, int len) {
        return this.writeUB1(len) + this.writeBytes(bytes, offset, len);
    }

    public int writeBytesWithLength2(byte[] bytes) {
        return this.writeBytesWithLength2(bytes, 0, bytes.length);
    }

    public int writeBytesWithLength2(byte[] bytes, int offset, int len) {
        return this.writeUB2(len) + this.writeBytes(bytes, offset, len);
    }

    public int writeBytesWithLength3(byte[] bytes) {
        return this.writeBytesWithLength3(bytes, 0, bytes.length);
    }

    public int writeBytesWithLength3(byte[] bytes, int offset, int len) {
        return this.writeUB3(len) + this.writeBytes(bytes, offset, len);
    }

    public int writeBytesWithNTS(byte[] bytes, int offset, int len) {
        return this.writeBytes(bytes) + this.writeByte((byte)0);
    }

    public int writeStringWithLength(String str, Charset encoding) {
        byte[] bytes = ByteUtil.fromString(str, encoding);
        return this.writeBytesWithLength(bytes, 0, bytes.length);
    }

    public int writeStringWithLength1(String str, Charset encoding) {
        byte[] bytes = ByteUtil.fromString(str, encoding);
        return this.writeBytesWithLength1(bytes, 0, bytes.length);
    }

    public int writeStringWithLength2(String str, Charset encoding) {
        byte[] bytes = ByteUtil.fromString(str, encoding);
        return this.writeBytesWithLength2(bytes, 0, bytes.length);
    }

    public int writeStringWithLength3(String str, Charset encoding) {
        byte[] bytes = ByteUtil.fromString(str, encoding);
        return this.writeBytesWithLength3(bytes, 0, bytes.length);
    }

    public int writeStringWithNTS(String str, Charset encoding) {
        byte[] bytes = ByteUtil.fromString(str, encoding);
        return this.writeBytesWithNTS(bytes, 0, bytes.length);
    }

    public byte readByte() {
        if (this.current.available(false) >= 1) {
            return this.current.readByte();
        }
        return ByteUtil.toByte(this.readBytes(1));
    }

    public short readShort() {
        if (this.current.available(false) >= 2) {
            return this.current.readShort();
        }
        return ByteUtil.toShort(this.readBytes(2));
    }

    public int readInt() {
        if (this.current.available(false) >= 4) {
            return this.current.readInt();
        }
        return ByteUtil.toInt(this.readBytes(4));
    }

    public long readLong() {
        if (this.current.available(false) >= 8) {
            return this.current.readLong();
        }
        return ByteUtil.toLong(this.readBytes(8));
    }

    public float readFloat() {
        if (this.current.available(false) >= 4) {
            return this.current.readFloat();
        }
        return ByteUtil.toFloat(this.readBytes(4));
    }

    public double readDouble() {
        if (this.current.available(false) >= 8) {
            return this.current.readDouble();
        }
        return ByteUtil.toDouble(this.readBytes(8));
    }

    public int readUB1() {
        if (this.current.available(false) >= 1) {
            return this.current.readUB1();
        }
        return ByteUtil.toUB1(this.readBytes(1));
    }

    public int readUB2() {
        if (this.current.available(false) >= 2) {
            return this.current.readUB2();
        }
        return ByteUtil.toUB2(this.readBytes(2));
    }

    public int readUB3() {
        return ByteUtil.toUB3(this.readBytes(3));
    }

    public long readUB4() {
        if (this.current.available(false) >= 4) {
            return this.current.readUB4();
        }
        return ByteUtil.toUB4(this.readBytes(4));
    }

    public byte[] readBytes(int len) {
        return this.readBytes(new byte[len], 0, len);
    }

    public byte[] readBytes(byte[] bytes, int offset, int len) {
        while (len > 0) {
            int rlen;
            int available = this.current.available(false);
            if ((len -= (rlen = this.current.readBytes(bytes, offset, available < len ? available : len))) <= 0) break;
            this.current = this.current.next;
            if (this.current == null) {
                throw new RuntimeException("index out of range");
            }
            offset += rlen;
        }
        return bytes;
    }

    public byte[] readBytesWithLength() {
        return this.readBytes(this.readInt());
    }

    public byte[] readBytesWithLength1() {
        return this.readBytes(this.readUB1());
    }

    public byte[] readBytesWithLength2() {
        return this.readBytes(this.readUB2());
    }

    public byte[] readBytesWithLength3() {
        return this.readBytes(this.readUB3());
    }

    public byte[] readBytesWithNTS() {
        int len = 0;
        do {
            ++len;
        } while (this.readByte() != 0);
        this.skip(len, false, false);
        byte[] bytes = this.readBytes(len - 1);
        this.readByte();
        return bytes;
    }

    public String readString(int len, Charset encoding) {
        return ByteUtil.toString(this.readBytes(len), encoding);
    }

    public String readStringWithLength(Charset encoding) {
        return ByteUtil.toString(this.readBytesWithLength(), encoding);
    }

    public String readStringWithLength1(Charset encoding) {
        return ByteUtil.toString(this.readBytesWithLength1(), encoding);
    }

    public String readStringWithLength2(Charset encoding) {
        return ByteUtil.toString(this.readBytesWithLength2(), encoding);
    }

    public String readStringWithLength3(Charset encoding) {
        return ByteUtil.toString(this.readBytesWithLength3(), encoding);
    }

    public String readStringWithNTS(Charset encoding) {
        return ByteUtil.toString(this.readBytesWithNTS(), encoding);
    }

    public int setByte(int offset, byte b2) {
        BufferNode<?> node = this.locate(offset);
        if (node.capacity() - node.extra >= 1) {
            return node.setByte(node.extra, b2);
        }
        return this.setBytes(node, ByteUtil.fromByte(b2));
    }

    public int setShort(int offset, short s2) {
        BufferNode<?> node = this.locate(offset);
        if (node.capacity() - node.extra >= 2) {
            return node.setShort(node.extra, s2);
        }
        return this.setBytes(node, ByteUtil.fromShort(s2));
    }

    public int setInt(int offset, int i2) {
        BufferNode<?> node = this.locate(offset);
        if (node.capacity() - node.extra >= 4) {
            return node.setInt(node.extra, i2);
        }
        return this.setBytes(node, ByteUtil.fromInt(i2));
    }

    public int setLong(int offset, long l2) {
        BufferNode<?> node = this.locate(offset);
        if (node.capacity() - node.extra >= 8) {
            return node.setLong(node.extra, l2);
        }
        return this.setBytes(node, ByteUtil.fromLong(l2));
    }

    public int setFloat(int offset, float f2) {
        BufferNode<?> node = this.locate(offset);
        if (node.capacity() - node.extra >= 4) {
            return node.setFloat(node.extra, f2);
        }
        return this.setBytes(node, ByteUtil.fromFloat(f2));
    }

    public int setDouble(int offset, double d2) {
        BufferNode<?> node = this.locate(offset);
        if (node.capacity() - node.extra >= 8) {
            return node.setDouble(node.extra, d2);
        }
        return this.setBytes(node, ByteUtil.fromDouble(d2));
    }

    public int setUB1(int offset, int i2) {
        BufferNode<?> node = this.locate(offset);
        if (node.capacity() - node.extra >= 1) {
            return node.setUB1(node.extra, i2);
        }
        return this.setBytes(node, ByteUtil.fromUB1(i2));
    }

    public int setUB2(int offset, int i2) {
        BufferNode<?> node = this.locate(offset);
        if (node.capacity() - node.extra >= 2) {
            return node.setUB2(node.extra, i2);
        }
        return this.setBytes(node, ByteUtil.fromUB2(i2));
    }

    public int setUB3(int offset, int i2) {
        BufferNode<?> node = this.locate(offset);
        return this.setBytes(node, ByteUtil.fromUB3(i2));
    }

    public int setUB4(int offset, long l2) {
        BufferNode<?> node = this.locate(offset);
        if (node.capacity() - node.extra >= 4) {
            return node.setUB4(node.extra, l2);
        }
        return this.setBytes(node, ByteUtil.fromUB4(l2));
    }

    public int setBytes(int offset, byte[] srcBytes) {
        return this.setBytes(this.locate(offset), srcBytes);
    }

    public int setBytes(int offset, byte[] srcBytes, int srcOffset, int len) {
        return this.setBytes(this.locate(offset), srcBytes, srcOffset, len);
    }

    private int setBytes(BufferNode<?> node, byte[] srcBytes) {
        return this.setBytes(node, srcBytes, 0, srcBytes.length);
    }

    private int setBytes(BufferNode<?> node, byte[] srcBytes, int srcOffset, int len) {
        int offset = node.extra;
        while (len > 0) {
            int slen;
            int available = node.capacity - offset;
            if ((len -= (slen = node.setBytes(offset, srcBytes, srcOffset, available < len ? available : len))) <= 0) break;
            node = node.next;
            if (node == null) {
                throw new RuntimeException("index out of range");
            }
            offset = 0;
            srcOffset += slen;
        }
        return len;
    }

    public int setBytesWithLength(int offset, byte[] srcBytes) {
        return this.setBytesWithLength(offset, srcBytes, 0, srcBytes.length);
    }

    public int setBytesWithLength(int offset, byte[] srcBytes, int srcOffset, int len) {
        return this.setInt(offset, len) + this.setBytes(offset + 4, srcBytes, srcOffset, len);
    }

    public int setBytesWithLength1(int offset, byte[] srcBytes) {
        return this.setBytesWithLength1(offset, srcBytes, 0, srcBytes.length);
    }

    public int setBytesWithLength1(int offset, byte[] srcBytes, int srcOffset, int len) {
        return this.setUB1(offset, len) + this.setBytes(offset + 1, srcBytes, srcOffset, len);
    }

    public int setBytesWithLength2(int offset, byte[] srcBytes) {
        return this.setBytesWithLength2(offset, srcBytes, 0, srcBytes.length);
    }

    public int setBytesWithLength2(int offset, byte[] srcBytes, int srcOffset, int len) {
        return this.setUB2(offset, len) + this.setBytes(offset + 2, srcBytes, srcOffset, len);
    }

    public int setBytesWithLength3(int offset, byte[] srcBytes) {
        return this.setBytesWithLength3(offset, srcBytes, 0, srcBytes.length);
    }

    public int setBytesWithLength3(int offset, byte[] srcBytes, int srcOffset, int len) {
        return this.setUB3(offset, len) + this.setBytes(offset + 3, srcBytes, srcOffset, len);
    }

    public int setBytesWithNTS(int offset, byte[] srcBytes) {
        return this.setBytes(offset, srcBytes, 0, srcBytes.length) + this.setByte(offset + srcBytes.length, (byte)0);
    }

    public int setStringWithLength(int offset, String str, Charset encoding) {
        byte[] srcBytes = ByteUtil.fromString(str, encoding);
        return this.setBytesWithLength(offset, srcBytes, 0, srcBytes.length);
    }

    public int setStringWithLength1(int offset, String str, Charset encoding) {
        byte[] srcBytes = ByteUtil.fromString(str, encoding);
        return this.setBytesWithLength1(offset, srcBytes, 0, srcBytes.length);
    }

    public int setStringWithLength2(int offset, String str, Charset encoding) {
        byte[] srcBytes = ByteUtil.fromString(str, encoding);
        return this.setBytesWithLength2(offset, srcBytes, 0, srcBytes.length);
    }

    public int setStringWithLength3(int offset, String str, Charset encoding) {
        byte[] srcBytes = ByteUtil.fromString(str, encoding);
        return this.setBytesWithLength3(offset, srcBytes, 0, srcBytes.length);
    }

    public int setStringWithNTS(int offset, String str, Charset encoding) {
        byte[] srcBytes = ByteUtil.fromString(str, encoding);
        return this.setBytesWithNTS(offset, srcBytes);
    }

    public byte getByte(int offset) {
        BufferNode<?> node = this.locate(offset);
        if (node.capacity() - node.extra >= 1) {
            return node.getByte(node.extra);
        }
        return ByteUtil.toByte(this.getBytes(node, 1));
    }

    public short getShort(int offset) {
        BufferNode<?> node = this.locate(offset);
        if (node.capacity() - node.extra >= 2) {
            return node.getShort(node.extra);
        }
        return ByteUtil.toShort(this.getBytes(node, 2));
    }

    public int getInt(int offset) {
        BufferNode<?> node = this.locate(offset);
        if (node.capacity() - node.extra >= 4) {
            return node.getInt(node.extra);
        }
        return ByteUtil.toInt(this.getBytes(node, 4));
    }

    public long getLong(int offset) {
        BufferNode<?> node = this.locate(offset);
        if (node.capacity() - node.extra >= 8) {
            return node.getLong(node.extra);
        }
        return ByteUtil.toLong(this.getBytes(node, 8));
    }

    public float getFloat(int offset) {
        BufferNode<?> node = this.locate(offset);
        if (node.capacity() - node.extra >= 4) {
            return node.getFloat(node.extra);
        }
        return ByteUtil.toFloat(this.getBytes(node, 4));
    }

    public double getDouble(int offset) {
        BufferNode<?> node = this.locate(offset);
        if (node.capacity() - node.extra >= 8) {
            return node.getDouble(node.extra);
        }
        return ByteUtil.toDouble(this.getBytes(node, 8));
    }

    public int getUB1(int offset) {
        BufferNode<?> node = this.locate(offset);
        if (node.capacity() - node.extra >= 1) {
            return node.getUB1(node.extra);
        }
        return ByteUtil.toUB1(this.getBytes(node, 1));
    }

    public int getUB2(int offset) {
        BufferNode<?> node = this.locate(offset);
        if (node.capacity() - node.extra >= 2) {
            return node.getUB2(node.extra);
        }
        return ByteUtil.toUB2(this.getBytes(node, 2));
    }

    public int getUB3(int offset) {
        BufferNode<?> node = this.locate(offset);
        return ByteUtil.toUB3(this.getBytes(node, 3));
    }

    public long getUB4(int offset) {
        BufferNode<?> node = this.locate(offset);
        if (node.capacity() - node.extra >= 4) {
            return node.getUB4(node.extra);
        }
        return ByteUtil.toUB4(this.getBytes(node, 4));
    }

    public byte[] getBytes(int offset, int len) {
        return this.getBytes(this.locate(offset), len);
    }

    public byte[] getBytes(int offset, byte[] destBytes) {
        return this.getBytes(this.locate(offset), destBytes);
    }

    public byte[] getBytes(int offset, byte[] destBytes, int destOffset, int len) {
        return this.getBytes(this.locate(offset), destBytes, destOffset, len);
    }

    private byte[] getBytes(BufferNode<?> node, int len) {
        return this.getBytes(node, new byte[len], 0, len);
    }

    private byte[] getBytes(BufferNode<?> node, byte[] destBytes) {
        return this.getBytes(node, destBytes, 0, destBytes.length);
    }

    private byte[] getBytes(BufferNode<?> node, byte[] destBytes, int destOffset, int len) {
        int offset = node.extra;
        while (len > 0) {
            int glen;
            int available = node.capacity - offset;
            if ((len -= (glen = node.getBytes(offset, destBytes, destOffset, available < len ? available : len))) <= 0) break;
            node = node.next;
            if (node == null) {
                throw new RuntimeException("index out of range");
            }
            offset = 0;
            destOffset += glen;
        }
        return destBytes;
    }

    public byte[] getBytesWithLength(int offset) {
        return this.getBytes(offset + 4, this.getInt(offset));
    }

    public byte[] getBytesWithLength1(int offset) {
        return this.getBytes(offset + 1, this.getUB1(offset));
    }

    public byte[] getBytesWithLength2(int offset) {
        return this.getBytes(offset + 2, this.getUB2(offset));
    }

    public byte[] getBytesWithLength3(int offset) {
        return this.getBytes(offset + 3, this.getUB3(offset));
    }

    public byte[] getBytesWithNTS(int offset) {
        int len = 0;
        int orgOffset = offset;
        while (this.getByte(offset++) != 0) {
            ++len;
        }
        return this.getBytes(orgOffset, len);
    }

    public String getStringWithLength(int offset, Charset encoding) {
        byte[] bytes = this.getBytesWithLength(offset);
        return ByteUtil.toString(bytes, encoding);
    }

    public String getStringWithLength1(int offset, Charset encoding) {
        byte[] bytes = this.getBytesWithLength1(offset);
        return ByteUtil.toString(bytes, encoding);
    }

    public String getStringWithLength2(int offset, Charset encoding) {
        byte[] bytes = this.getBytesWithLength2(offset);
        return ByteUtil.toString(bytes, encoding);
    }

    public String getStringWithLength3(int offset, Charset encoding) {
        byte[] bytes = this.getBytesWithLength3(offset);
        return ByteUtil.toString(bytes, encoding);
    }

    public String getStringWithNTS(int offset, Charset encoding) {
        byte[] bytes = this.getBytesWithNTS(offset);
        return ByteUtil.toString(bytes, encoding);
    }
}

